/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.processing.mandrel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.Petrolpark;
import com.petrolpark.compat.create.PetrolparkPartialModels;
import com.petrolpark.compat.create.common.processing.mandrel.MandrelBlock;
import com.petrolpark.compat.create.common.processing.mandrel.MandrelBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class MandrelRenderer
extends KineticBlockEntityRenderer<MandrelBlockEntity> {
    public MandrelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(MandrelBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = this.getRenderedBlockState(be);
        MandrelRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getRotatedModel(be, state), (PoseStack)ms, (VertexConsumer)buffer.getBuffer(this.getRenderType(be, state)), (int)light);
        this.renderAnimation(be, partialTicks, ms, buffer, light, overlay);
    }

    public void renderAnimation(MandrelBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.running) {
            return;
        }
        Direction.Axis axis = ((IRotate)be.getBlockState().getBlock()).getRotationAxis(be.getBlockState());
        float angleRemainingAfterStart = be.getSpeed() < 0.0f ? -this.getStartAngle(be, axis) : (float)Math.PI * 2 - this.getStartAngle(be, axis);
        float partialTicksTil0 = angleRemainingAfterStart / (be.getSpeed() * 3.0f / 10.0f * ((float)Math.PI / 180));
        float partialTicksRunning = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel()) - (be.animationStartPartialTick + partialTicksTil0);
        if (partialTicksRunning < 0.0f) {
            return;
        }
        Petrolpark.LOGGER.info("0");
    }

    public float getStartAngle(MandrelBlockEntity be, Direction.Axis axis) {
        float time = be.animationStartPartialTick;
        float offset = MandrelRenderer.getRotationOffsetForPosition((KineticBlockEntity)be, (BlockPos)be.getBlockPos(), (Direction.Axis)axis);
        float angle = (time * be.getSpeed() * 3.0f / 10.0f + offset) % 360.0f * ((float)Math.PI / 180);
        return angle;
    }

    protected SuperByteBuffer getRotatedModel(MandrelBlockEntity be, BlockState state) {
        return CachedBuffers.partialFacing((PartialModel)PetrolparkPartialModels.MANDREL_SHAFT, (BlockState)state, (Direction)((Direction)state.getValue(MandrelBlock.HORIZONTAL_FACING)).getOpposite());
    }
}

