/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.redstone.programmer;

import com.mojang.serialization.Codec;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgram;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgrammerMenu;
import com.petrolpark.util.NBTHelper;
import com.simibubi.create.content.equipment.clipboard.ClipboardCloneable;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import net.createmod.catnip.data.Couple;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class RedstoneProgrammerBehaviour
extends BlockEntityBehaviour
implements ClipboardCloneable,
MenuProvider {
    public static final BehaviourType<RedstoneProgrammerBehaviour> TYPE = new BehaviourType();
    protected final BooleanSupplier powerChecker;
    public final BehaviourRedstoneProgram program;
    public final Codec<BehaviourRedstoneProgram> programCodec;

    public RedstoneProgrammerBehaviour(SmartBlockEntity be, BooleanSupplier powerChecker) {
        super(be);
        this.powerChecker = powerChecker;
        this.program = new BehaviourRedstoneProgram();
        this.programCodec = RedstoneProgram.codec(this.program::copyFrom);
    }

    public void initialize() {
        super.initialize();
        if (this.getWorld().isClientSide()) {
            return;
        }
        this.program.load();
    }

    public void unload() {
        super.unload();
        if (this.getWorld().isClientSide()) {
            return;
        }
        this.program.unload();
    }

    public void tick() {
        this.program.tick();
        super.tick();
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(nbt, registries, clientPacket);
        NBTHelper.read(registries, this.programCodec, nbt.get("Program"));
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(nbt, registries, clientPacket);
        nbt.put("Program", NBTHelper.write(registries, this.programCodec, this.program));
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public String getClipboardKey() {
        return "Frequencies";
    }

    public boolean writeToClipboard(@NotNull HolderLookup.Provider registries, CompoundTag tag, Direction side) {
        tag.put("RedstoneProgram", NBTHelper.write(registries, this.programCodec, this.program));
        return true;
    }

    public boolean readFromClipboard(@NotNull HolderLookup.Provider registries, CompoundTag tag, Player player, Direction side, boolean simulate) {
        if (tag.contains("RedstoneProgram")) {
            if (!simulate) {
                NBTHelper.read(registries, this.programCodec, (Tag)tag);
            }
            return true;
        }
        if (tag.contains("FrequencyFirst") || !tag.contains("FrequencyLast")) {
            Couple frequencies = Couple.create((Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("FrequencyFirst"))), (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("FrequencyLast"))));
            if (this.program.getChannels().stream().anyMatch(channel -> channel.networkKey.equals((Object)frequencies))) {
                return false;
            }
            if (!simulate) {
                this.program.addBlankChannel((Couple<RedstoneLinkNetworkHandler.Frequency>)frequencies);
            }
            return true;
        }
        return false;
    }

    public AbstractContainerMenu createMenu(int containerId, @Nonnull Inventory playerInventory, @Nonnull Player player) {
        return RedstoneProgrammerMenu.create(containerId, playerInventory, this.program);
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    public class BehaviourRedstoneProgram
    extends RedstoneProgram {
        @Override
        public boolean hasPower() {
            return RedstoneProgrammerBehaviour.this.powerChecker.getAsBoolean();
        }

        @Override
        public BlockPos getBlockPos() {
            return RedstoneProgrammerBehaviour.this.getPos();
        }

        @Override
        public boolean shouldTransmit() {
            Level level = RedstoneProgrammerBehaviour.super.getWorld();
            BlockPos pos = RedstoneProgrammerBehaviour.this.getPos();
            if (RedstoneProgrammerBehaviour.this.blockEntity.isChunkUnloaded()) {
                return false;
            }
            if (RedstoneProgrammerBehaviour.this.blockEntity.isRemoved()) {
                return false;
            }
            if (!level.isLoaded(pos)) {
                return false;
            }
            return level.getBlockEntity(pos) == RedstoneProgrammerBehaviour.this.blockEntity;
        }

        @Override
        public LevelAccessor getWorld() {
            return RedstoneProgrammerBehaviour.super.getWorld();
        }

        @Override
        public void whenChanged() {
            RedstoneProgrammerBehaviour.this.blockEntity.notifyUpdate();
            RedstoneProgrammerBehaviour.this.program.load();
        }

        @Override
        public void tick() {
            super.tick();
        }

        @Override
        public BehaviourRedstoneProgram copyFrom(RedstoneProgram.PlayMode mode, int length, int playtime, int ticksToNextBeat, boolean paused, boolean pausedLastTick, boolean poweredLastTick, List<RedstoneProgram.ChannelData> channels, int ticksPerBeat, int beatsPerLine, int linesPerBar) {
            super.copyFrom(mode, length, playtime, ticksToNextBeat, paused, pausedLastTick, poweredLastTick, channels, ticksPerBeat, beatsPerLine, linesPerBar);
            return this;
        }

        @Override
        public Object getHashSalt() {
            return this.getBlockPos();
        }
    }
}

