/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.redstone.programmer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.compat.create.PetrolparkPartialModels;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgram;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgrammerBlockItem;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.Optional;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;

public class RedstoneProgrammerItemRenderer
extends CustomRenderedItemModelRenderer {
    protected void render(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        Minecraft mc = Minecraft.getInstance();
        renderer.render(model.getOriginalModel(), light);
        Optional<RedstoneProgrammerBlockItem.ItemStackRedstoneProgram> programOptional = RedstoneProgrammerBlockItem.getProgram(stack, (LevelAccessor)mc.level, (LivingEntity)mc.player);
        boolean running = transformType != ItemDisplayContext.GROUND && transformType != ItemDisplayContext.FIXED && programOptional.map(program -> !program.paused).orElse(false) != false;
        float rotation = running ? AnimationTickHolder.getRenderTime() : 0.0f;
        ms.pushPose();
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).uncenter()).translate(0.0, 0.375, 0.625)).rotateXDegrees(rotation)).translateBack(0.0, 0.375, 0.625)).center();
        renderer.render(PetrolparkPartialModels.REDSTONE_PROGRAMMER_CYLINDER.get(), light);
        ms.popPose();
        ms.pushPose();
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).uncenter()).translate(0.0, 0.53125, 0.34375)).rotateXDegrees(-2.0f + 8.0f * -Mth.sin((float)(4.0f * AngleHelper.rad((double)rotation))))).translateBack(0.0, 0.53125, 0.34375)).center();
        renderer.render(PetrolparkPartialModels.REDSTONE_PROGRAMMER_NEEDLE.get(), light);
        ms.popPose();
        if (programOptional.isEmpty()) {
            return;
        }
        RedstoneProgram program2 = programOptional.get();
        ImmutableList<RedstoneProgram.Channel> channels = program2.getChannels();
        for (int i = 0; i < 6; ++i) {
            if (i >= channels.size()) continue;
            boolean powered = running && ((RedstoneProgram.Channel)program2.getChannels().get(i)).getTransmittedStrength() != 0;
            ms.pushPose();
            ms.translate(i % 2 == 0 ? 0.0f : 0.9375f, 0.0625f, (3.0f + 4.5f * (float)(i / 2)) / 16.0f);
            renderer.render((powered ? PetrolparkPartialModels.REDSTONE_PROGRAMMER_TRANSMITTER_POWERED : PetrolparkPartialModels.REDSTONE_PROGRAMMER_TRANSMITTER).get(), light);
            ms.popPose();
        }
    }
}

