/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.redstone.programmer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.client.rendering.PetrolparkGuiTexture;
import com.petrolpark.compat.create.CreateBlocks;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgram;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgrammerBlock;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgrammerMenu;
import com.petrolpark.compat.create.common.redstone.programmer.SetRedstoneProgramPacket;
import com.petrolpark.compat.jei.ghost.IConditionalGhostSlot;
import com.petrolpark.config.PetrolparkConfigs;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class RedstoneProgrammerScreen
extends AbstractSimiContainerScreen<RedstoneProgrammerMenu> {
    protected final RedstoneProgrammerMenu menu;
    public final RedstoneProgram program;
    private final PetrolparkGuiTexture background;
    private final int width;
    public static final Rect2i NOTE_AREA = new Rect2i(77, 31, 168, 154);
    public static final Rect2i ITEM_AREA = new Rect2i(3, 31, 73, 154);
    public static final int DISTANCE_BETWEEN_CHANNELS = 20;
    private static final int noteWidth = 4;
    private int verticalScroll;
    private final LerpedFloat horizontalScroll = LerpedFloat.linear().startWithValue(0.0);
    private final LerpedFloat playhead = LerpedFloat.linear().startWithValue(0.0);
    private boolean followPlayHead = false;
    private boolean dragging;
    private int draggingChannel;
    private boolean draggingDeleting;
    private IconButton playPauseButton;
    private IconButton restartButton;
    private IconButton confirmButton;
    private final Map<RedstoneProgram.PlayMode, IconButton> modeButtons;
    private IconButton followPlayheadButton;
    private ScrollInput ticksPerBeatScroller;
    private ScrollInput beatsPerLineScroller;
    private ScrollInput linesPerBarScroller;
    private boolean shouldSend;

    public RedstoneProgrammerScreen(RedstoneProgrammerMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.menu = container;
        this.program = (RedstoneProgram)container.contentHolder;
        this.background = PetrolparkGuiTexture.REDSTONE_PROGRAMMER;
        this.width = this.background.width;
        this.modeButtons = new HashMap<RedstoneProgram.PlayMode, IconButton>(RedstoneProgram.PlayMode.values().length);
        this.playhead.setValue((double)(4.0f * (float)this.program.getAbsolutePlaytime()));
    }

    protected void init() {
        this.setWindowSize(this.width, this.background.height);
        super.init();
        this.clearWidgets();
        this.playPauseButton = (IconButton)new IconButton(this.leftPos + 7, this.topPos + 6, (ScreenElement)AllIcons.I_PLAY).withCallback(() -> {
            boolean bl = this.program.paused = !this.program.paused;
            if (this.program.mode.powerRequired || this.program.mode == RedstoneProgram.PlayMode.LOOP) {
                this.program.mode = RedstoneProgram.PlayMode.MANUAL;
            }
            this.setPlayPauseButtonIcon();
            this.shouldSend = true;
        });
        this.setPlayPauseButtonIcon();
        this.addRenderableWidget((GuiEventListener)this.playPauseButton);
        this.restartButton = (IconButton)new IconButton(this.leftPos + 29, this.topPos + 6, (ScreenElement)AllIcons.I_REFRESH).withCallback(() -> {
            this.program.restart();
            this.playhead.setValue(0.0);
            if (!this.followPlayHead) {
                this.horizontalScroll.setValue(0.0);
                this.horizontalScroll.chase(0.0, 1.0, LerpedFloat.Chaser.LINEAR);
            }
            this.shouldSend = true;
        });
        this.addRenderableWidgets((GuiEventListener[])new IconButton[]{this.restartButton});
        this.confirmButton = new IconButton(this.leftPos + this.width - 33, this.topPos + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> {
            Minecraft minecraft = this.minecraft;
            if (minecraft != null && minecraft.player != null) {
                minecraft.player.closeContainer();
            }
        });
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.modeButtons.clear();
        for (RedstoneProgram.PlayMode mode : RedstoneProgram.PlayMode.values()) {
            IconButton button = new IconButton(this.leftPos + 27 + mode.ordinal() * 18, this.topPos + this.background.height - 24, (ScreenElement)mode.icon);
            button.setToolTip(mode.description);
            button.withCallback(() -> {
                this.shouldSend = this.program.mode != mode;
                this.program.mode = mode;
                if (this.shouldSend && mode == RedstoneProgram.PlayMode.LOOP) {
                    this.program.paused = false;
                }
            });
            button.active = this.program.mode != mode;
            this.modeButtons.put(mode, button);
            this.addRenderableWidget((GuiEventListener)button);
        }
        this.ticksPerBeatScroller = new ScrollInput(this.leftPos + 6, this.topPos + this.background.height - 24, 18, 9).setState(this.program.getTicksPerBeat()).calling(i -> {
            this.program.setTicksPerBeat((int)i);
            this.shouldSend = true;
        }).titled(RedstoneProgrammerScreen.translate("ticks_per_beat")).addHint(RedstoneProgrammerScreen.translate("ticks_per_beat.hint")).withRange(((Integer)PetrolparkConfigs.server().redstoneProgrammerMinTicksPerBeat.get()).intValue(), 81);
        this.ticksPerBeatScroller.setState(this.program.getTicksPerBeat());
        this.addRenderableWidget((GuiEventListener)this.ticksPerBeatScroller);
        this.beatsPerLineScroller = new ScrollInput(this.leftPos + 156, this.topPos + this.background.height - 24, 18, 9).setState(this.program.beatsPerLine).calling(i -> {
            this.program.beatsPerLine = i;
            this.shouldSend = true;
        }).titled(RedstoneProgrammerScreen.translate("beats_per_line")).addHint(RedstoneProgrammerScreen.translate("beats_per_line.hint")).withRange(0, 32);
        this.beatsPerLineScroller.setState(this.program.beatsPerLine);
        this.addRenderableWidget((GuiEventListener)this.beatsPerLineScroller);
        this.linesPerBarScroller = new ScrollInput(this.leftPos + 176, this.topPos + this.background.height - 24, 18, 9).setState(this.program.linesPerBar).calling(i -> {
            this.program.linesPerBar = i;
            this.shouldSend = true;
        }).titled(RedstoneProgrammerScreen.translate("lines_per_bar")).addHint(RedstoneProgrammerScreen.translate("lines_per_bar.hint")).withRange(0, 32);
        this.linesPerBarScroller.setState(this.program.linesPerBar);
        this.addRenderableWidget((GuiEventListener)this.linesPerBarScroller);
        this.followPlayheadButton = (IconButton)new IconButton(this.leftPos + 196, this.topPos + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIG_OPEN).withCallback(() -> {
            this.followPlayHead = true;
        });
        this.followPlayheadButton.setToolTip((Component)RedstoneProgrammerScreen.translate("follow_playhead"));
        this.addRenderableWidget((GuiEventListener)this.followPlayheadButton);
    }

    public void containerTick() {
        super.containerTick();
        float speed = 4.0f / (float)this.program.getTicksPerBeat();
        this.playhead.chase((double)(4.0f * (float)this.program.getAbsolutePlaytime() / (float)this.program.getTicksPerBeat()), (double)speed, LerpedFloat.Chaser.LINEAR);
        if (this.followPlayHead) {
            this.clampHorizontalScroll((double)this.playhead.getChaseTarget() - 20.0, speed);
        }
        if (Math.abs(this.playhead.getValue() - this.playhead.getChaseTarget()) > speed * 2.0f) {
            this.playhead.setValue((double)this.playhead.getChaseTarget());
        }
        if (this.followPlayHead && Math.abs(this.horizontalScroll.getValue() - this.horizontalScroll.getChaseTarget()) > speed * 2.0f) {
            this.horizontalScroll.setValue((double)this.horizontalScroll.getChaseTarget());
        }
        this.horizontalScroll.tickChaser();
        this.playhead.tickChaser();
        for (Map.Entry<RedstoneProgram.PlayMode, IconButton> entry : this.modeButtons.entrySet()) {
            entry.getValue().active = this.program.mode != entry.getKey();
        }
        this.program.tick();
        this.setPlayPauseButtonIcon();
        if (this.shouldSend) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new SetRedstoneProgramPacket(this.program));
            this.shouldSend = false;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int mX = (int)mouseX - this.getGuiLeft();
        int mY = (int)mouseY - this.getGuiTop();
        boolean inNoteArea = NOTE_AREA.contains(mX, mY);
        boolean inItemArea = ITEM_AREA.contains(mX, mY);
        if (inItemArea || inNoteArea) {
            double relativeMouseX = (float)(mX - NOTE_AREA.getX()) + this.horizontalScroll.getChaseTarget();
            if (inNoteArea && mY > NOTE_AREA.getY() + 70 && mY < NOTE_AREA.getY() + 82) {
                int programWidth = this.program.getLength() * 4;
                if (relativeMouseX > (double)(programWidth + 10) && relativeMouseX < (double)(programWidth + 22)) {
                    if (this.program.getLength() <= 1) {
                        return super.mouseClicked(mouseX, mouseY, button);
                    }
                    if (this.program.beatsPerLine == 0 || this.program.linesPerBar == 0 || Screen.hasShiftDown()) {
                        this.program.setDuration(this.program.getLength() - 1);
                    } else {
                        this.program.setDuration(Math.max(1, this.program.beatsPerLine * this.program.linesPerBar * ((this.program.getLength() - 1) / (this.program.beatsPerLine * this.program.linesPerBar))));
                    }
                } else if (relativeMouseX > (double)(programWidth + 26) && relativeMouseX < (double)(programWidth + 38)) {
                    if (this.program.beatsPerLine == 0 || this.program.linesPerBar == 0 || Screen.hasShiftDown()) {
                        this.program.setDuration(this.program.getLength() + 1);
                    } else {
                        this.program.setDuration(this.program.beatsPerLine * this.program.linesPerBar * (this.program.getLength() / (this.program.beatsPerLine * this.program.linesPerBar) + 1));
                    }
                }
                this.shouldSend = true;
                return true;
            }
            ImmutableList<RedstoneProgram.Channel> channels = this.program.getChannels();
            double posInList = mY - NOTE_AREA.getY() + this.verticalScroll;
            int channelNo = (int)(posInList / 20.0);
            if (channelNo < 0 || channelNo >= channels.size()) {
                return super.mouseClicked(mouseX, mouseY, button);
            }
            RedstoneProgram.Channel channel = (RedstoneProgram.Channel)channels.get(channelNo);
            if (inNoteArea) {
                int note = (int)(relativeMouseX / 4.0);
                if (note < 0 || note >= this.program.getLength()) {
                    return super.mouseClicked(mouseX, mouseY, button);
                }
                this.dragging = true;
                this.draggingChannel = channelNo;
                this.draggingDeleting = channel.getStrength(note) != 0;
                channel.setStrength(note, this.draggingDeleting ? 0 : 15);
                this.followPlayHead = false;
                this.shouldSend = true;
                return true;
            }
            if (inItemArea) {
                boolean success = false;
                if (mX > ITEM_AREA.getX() + 4) {
                    if (mX < ITEM_AREA.getX() + 16) {
                        this.program.remove(channel);
                        this.clampVerticalScroll(this.verticalScroll);
                        success = true;
                    } else if (mX < ITEM_AREA.getX() + 32 && channelNo < channels.size() - 1) {
                        this.program.swap(channel, (RedstoneProgram.Channel)channels.get(channelNo + 1));
                        success = true;
                    }
                }
                if (success) {
                    this.menu.refreshSlots();
                    this.shouldSend = true;
                    return true;
                }
            }
        }
        this.dragging = false;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        double mX = mouseX - (double)this.getGuiLeft();
        double mY = mouseY - (double)this.getGuiTop();
        if (this.dragging && NOTE_AREA.contains((int)mX, (int)mY)) {
            ImmutableList<RedstoneProgram.Channel> channels = this.program.getChannels();
            if (this.draggingChannel < 0 || this.draggingChannel >= channels.size()) {
                return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
            }
            RedstoneProgram.Channel channel = (RedstoneProgram.Channel)channels.get(this.draggingChannel);
            int leftNote = (int)((mX - (double)NOTE_AREA.getX() + (double)this.horizontalScroll.getChaseTarget()) / 4.0);
            int i = 0;
            while ((double)i <= Math.abs(dragX) / 4.0) {
                int note = leftNote + i * (int)Math.signum(dragX);
                if (note >= 0 && note < this.program.getLength()) {
                    channel.setStrength(note, this.draggingDeleting ? 0 : 15);
                }
                ++i;
            }
            this.shouldSend = true;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        int mY;
        int mX = (int)mouseX - this.getGuiLeft();
        if (ITEM_AREA.contains(mX, mY = (int)mouseY - this.getGuiTop()) || deltaX != 0.0) {
            int oldScroll = this.verticalScroll;
            this.clampVerticalScroll(oldScroll + (int)deltaY * 5);
            if (deltaX == 0.0) {
                return true;
            }
        } else if (NOTE_AREA.contains(mX, mY)) {
            this.followPlayHead = false;
            ImmutableList<RedstoneProgram.Channel> channels = this.program.getChannels();
            double posInList = mY - NOTE_AREA.getY() + this.verticalScroll;
            int channelNo = (int)(posInList / 20.0);
            if (channelNo >= 0 && channelNo < channels.size()) {
                int strength;
                RedstoneProgram.Channel channel = (RedstoneProgram.Channel)channels.get(channelNo);
                int note = (int)(((float)(mX - NOTE_AREA.getX()) + this.horizontalScroll.getChaseTarget()) / 4.0f);
                if (note >= 0 && note < this.program.getLength() && (strength = channel.getStrength(note)) != 0) {
                    int maxSelectedNote = note;
                    if (!Screen.hasShiftDown()) {
                        for (int minSelectedNote = note; minSelectedNote > 0; --minSelectedNote) {
                            if (channel.getStrength(minSelectedNote) == strength) continue;
                            ++minSelectedNote;
                            break;
                        }
                        while (maxSelectedNote < this.program.getLength() - 1) {
                            if (channel.getStrength(maxSelectedNote) != strength) {
                                --maxSelectedNote;
                                break;
                            }
                            ++maxSelectedNote;
                        }
                    }
                    for (int i = minSelectedNote; i <= maxSelectedNote; ++i) {
                        channel.setStrength(i, Mth.clamp((int)(strength + (int)deltaY), (int)1, (int)15));
                    }
                    this.shouldSend = true;
                    return true;
                }
            }
            this.clampHorizontalScroll((double)this.horizontalScroll.getChaseTarget() + (deltaY == 0.0 ? -deltaX : deltaY) * 5.0, 10.0);
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        PoseStack ms = graphics.pose();
        ms.pushPose();
        this.background.render(graphics, this.leftPos, this.topPos);
        ms.translate((double)this.leftPos, (double)this.topPos, 0.0);
        float xOffset = this.horizontalScroll.getValue(partialTicks);
        float yOffset = -this.verticalScroll;
        graphics.drawString(this.font, (Component)RedstoneProgrammerScreen.translate("playback"), 6, this.background.height - 34, 5726074, false);
        graphics.drawString(this.font, (Component)RedstoneProgrammerScreen.translate("editor"), 156, this.background.height - 34, 5726074, false);
        int playtimeSeconds = this.program.getAbsolutePlaytime() / 20;
        int durationSeconds = this.program.getLength() * this.program.getTicksPerBeat() / 20;
        graphics.drawString(this.font, String.format("%02d:%02d / %02d:%02d", playtimeSeconds / 60, playtimeSeconds % 60, durationSeconds / 60, durationSeconds % 60), 128, 6, 5726074, false);
        graphics.drawString(this.font, (Component)Component.literal((String)("" + this.program.getTicksPerBeat())), 9, this.background.height - 19, 0xE0E0E0, true);
        graphics.drawString(this.font, (Component)Component.literal((String)("" + this.program.beatsPerLine)), 159, this.background.height - 19, 0xE0E0E0, true);
        graphics.drawString(this.font, (Component)Component.literal((String)("" + this.program.linesPerBar)), 179, this.background.height - 19, 0xE0E0E0, true);
        this.enableScissor(graphics, NOTE_AREA.getX(), NOTE_AREA.getY() - 11, NOTE_AREA.getWidth(), NOTE_AREA.getHeight() + 7);
        ms.pushPose();
        ms.translate((float)NOTE_AREA.getX(), (float)(NOTE_AREA.getY() - 10), 0.0f);
        if (this.program.beatsPerLine > 0) {
            int time = 0;
            while (time < this.program.getLength()) {
                float horizontalOffset = -xOffset + (float)(time * 4);
                if (horizontalOffset < 0.0f || horizontalOffset > (float)NOTE_AREA.getWidth()) {
                    time += this.program.beatsPerLine;
                    continue;
                }
                ms.pushPose();
                ms.translate(horizontalOffset, 0.0f, 0.0f);
                PetrolparkGuiTexture line = this.program.linesPerBar > 0 && time % (this.program.linesPerBar * this.program.beatsPerLine) == 0 ? PetrolparkGuiTexture.REDSTONE_PROGRAMMER_BARLINE : PetrolparkGuiTexture.REDSTONE_PROGRAMMER_LINE;
                line.render(graphics, 0, 0);
                ms.popPose();
                time += this.program.beatsPerLine;
            }
        }
        ms.pushPose();
        ms.translate(-xOffset + (float)(this.program.getLength() * 4), 0.0f, 0.0f);
        PetrolparkGuiTexture.REDSTONE_PROGRAMMER_BARLINE.render(graphics, 0, 0);
        ms.popPose();
        ms.popPose();
        graphics.disableScissor();
        int channelNo = 0;
        for (RedstoneProgram.Channel channel : this.program.getChannels()) {
            float verticalOffset = yOffset + (float)(channelNo * 20);
            if (verticalOffset < -20.0f || verticalOffset > (float)ITEM_AREA.getHeight()) {
                ++channelNo;
                continue;
            }
            this.enableScissor(graphics, ITEM_AREA.getX(), ITEM_AREA.getY(), ITEM_AREA.getWidth(), ITEM_AREA.getHeight());
            ms.pushPose();
            ms.translate((double)ITEM_AREA.getX(), (double)((float)ITEM_AREA.getY() + verticalOffset), 0.0);
            PetrolparkGuiTexture.REDSTONE_PROGRAMMER_ITEM_SLOTS.render(graphics, 31, 3);
            PetrolparkGuiTexture.REDSTONE_PROGRAMMER_DELETE_CHANNEL.render(graphics, 2, 3);
            if (channelNo < this.program.getChannels().size() - 1) {
                PetrolparkGuiTexture.REDSTONE_PROGRAMMER_MOVE_CHANNEL_DOWN.render(graphics, 16, 8);
            }
            graphics.renderItem(((RedstoneLinkNetworkHandler.Frequency)channel.getNetworkKey().getFirst()).getStack(), 32, 4);
            graphics.renderItem(((RedstoneLinkNetworkHandler.Frequency)channel.getNetworkKey().getSecond()).getStack(), 50, 4);
            ms.popPose();
            graphics.disableScissor();
            this.enableScissor(graphics, NOTE_AREA.getX(), NOTE_AREA.getY(), NOTE_AREA.getWidth(), NOTE_AREA.getHeight());
            for (int i = 0; i < this.program.getLength(); ++i) {
                boolean nextMatches;
                boolean previousMatches;
                float horizontalOffset = -xOffset + (float)(i * 4);
                if (horizontalOffset < -5.0f) continue;
                if (horizontalOffset > (float)NOTE_AREA.getWidth()) break;
                int strength = channel.getStrength(i);
                if (strength == 0) continue;
                boolean bl = i == 0 ? false : (previousMatches = channel.getStrength(i - 1) == strength);
                boolean bl2 = i == this.program.getLength() ? false : (nextMatches = channel.getStrength(i + 1) == strength);
                PetrolparkGuiTexture border = previousMatches ? (nextMatches ? PetrolparkGuiTexture.REDSTONE_PROGRAMMER_NOTE_BORDER_MIDDLE : PetrolparkGuiTexture.REDSTONE_PROGRAMMER_NOTE_BORDER_RIGHT) : (nextMatches ? PetrolparkGuiTexture.REDSTONE_PROGRAMMER_NOTE_BORDER_LEFT : PetrolparkGuiTexture.REDSTONE_PROGRAMMER_NOTE_BORDER_LONE);
                ms.pushPose();
                ms.translate((float)NOTE_AREA.getX() + horizontalOffset, (float)NOTE_AREA.getY() + verticalOffset, 0.0f);
                PetrolparkGuiTexture.getRedstoneProgrammerNote(strength).render(graphics, 0, 2);
                border.render(graphics, 0, 2);
                ms.popPose();
            }
            graphics.disableScissor();
            ++channelNo;
        }
        this.enableScissor(graphics, ITEM_AREA.getX(), ITEM_AREA.getY(), ITEM_AREA.getWidth(), ITEM_AREA.getHeight());
        if (channelNo < (Integer)PetrolparkConfigs.server().redstoneProgrammerMaxChannels.get()) {
            ms.pushPose();
            ms.translate((float)ITEM_AREA.getX(), (float)NOTE_AREA.getY() + yOffset + (float)(channelNo * 20), 0.0f);
            PetrolparkGuiTexture.REDSTONE_PROGRAMMER_ITEM_SLOTS.render(graphics, 31, 3);
            ms.popPose();
        }
        graphics.disableScissor();
        this.enableScissor(graphics, NOTE_AREA.getX(), NOTE_AREA.getY() - 11, NOTE_AREA.getWidth(), NOTE_AREA.getHeight() + 11);
        ms.pushPose();
        ms.translate((float)NOTE_AREA.getX() - xOffset, (float)(NOTE_AREA.getY() - 10), (float)channelNo);
        int programWidth = this.program.getLength() * 4;
        if (this.program.getLength() > 1) {
            PetrolparkGuiTexture.REDSTONE_PROGRAMMER_REMOVE_BAR.render(graphics, programWidth + 10, 80);
        }
        PetrolparkGuiTexture.REDSTONE_PROGRAMMER_ADD_BAR.render(graphics, programWidth + 26, 80);
        double relativeMouseX = (float)(mouseX - this.getGuiLeft() - NOTE_AREA.getX()) + xOffset;
        double relativeMouseY = mouseY - this.getGuiTop() - NOTE_AREA.getY();
        String renderedTooltip = "none";
        if (relativeMouseY > 70.0 && relativeMouseY < 82.0) {
            if (this.program.getLength() > 1 && relativeMouseX > (double)(programWidth + 10) && relativeMouseX < (double)(programWidth + 22)) {
                renderedTooltip = "remove";
            } else if (relativeMouseX > (double)(programWidth + 26) && relativeMouseX < (double)(programWidth + 38)) {
                renderedTooltip = "add";
            }
        }
        ms.pushPose();
        ms.translate(this.program.paused ? this.playhead.getValue() : this.playhead.getValue(partialTicks), 0.0f, 0.0f);
        PetrolparkGuiTexture.REDSTONE_PROGRAMMER_PLAYHEAD.render(graphics, -3, 0);
        ms.popPose();
        ms.popPose();
        graphics.disableScissor();
        graphics.fillGradient(ITEM_AREA.getX(), ITEM_AREA.getY(), ITEM_AREA.getX() + ITEM_AREA.getWidth(), ITEM_AREA.getY() + 10, 200, 0x77000000, 0);
        graphics.fillGradient(ITEM_AREA.getX(), ITEM_AREA.getY() + ITEM_AREA.getHeight() - 10, ITEM_AREA.getX() + ITEM_AREA.getWidth(), ITEM_AREA.getY() + ITEM_AREA.getHeight(), 200, 0, 0x70000000);
        ms.popPose();
        if ("remove".equals(renderedTooltip)) {
            graphics.renderTooltip(this.font, List.of(RedstoneProgrammerScreen.translate("remove_bar"), RedstoneProgrammerScreen.translate("remove_bar.hint")), Optional.empty(), mouseX, mouseY);
        } else if ("add".equals(renderedTooltip)) {
            graphics.renderTooltip(this.font, List.of(RedstoneProgrammerScreen.translate("add_bar"), RedstoneProgrammerScreen.translate("add_bar.hint")), Optional.empty(), mouseX, mouseY);
        }
    }

    protected void renderSlot(@Nonnull GuiGraphics guiGraphics, @Nonnull Slot slot) {
        this.enableScissor(guiGraphics, ITEM_AREA);
        super.renderSlot(guiGraphics, slot);
        guiGraphics.disableScissor();
    }

    protected void renderSlotHighlight(@Nonnull GuiGraphics guiGraphics, @Nonnull Slot slot, int mouseX, int mouseY, float partialTick) {
        IConditionalGhostSlot ghostSlot;
        if (slot instanceof IConditionalGhostSlot && (ghostSlot = (IConditionalGhostSlot)slot).canSetGhostItem()) {
            return;
        }
        super.renderSlotHighlight(guiGraphics, slot, mouseX, mouseY, partialTick);
    }

    public void clampVerticalScroll(int newScroll) {
        int oldScroll = this.verticalScroll;
        this.verticalScroll = Mth.clamp((int)newScroll, (int)0, (int)Math.max(0, 6 + Math.min(this.program.getChannels().size() + 1, (Integer)PetrolparkConfigs.server().redstoneProgrammerMaxChannels.get()) * 20 - ITEM_AREA.getHeight()));
        if (oldScroll != this.verticalScroll) {
            this.menu.refreshSlots(this.verticalScroll);
            this.shouldSend = true;
        }
    }

    public void clampHorizontalScroll(double newScroll, double speed) {
        this.horizontalScroll.chase(Mth.clamp((double)newScroll, (double)0.0, (double)Math.max(46.0 - (double)NOTE_AREA.getWidth() + (double)(this.program.getLength() * 4), 0.0)), speed, LerpedFloat.Chaser.LINEAR);
    }

    public void setPlayPauseButtonIcon() {
        this.playPauseButton.setIcon((ScreenElement)(this.program.paused ? AllIcons.I_PLAY : AllIcons.I_PAUSE));
    }

    public static final MutableComponent translate(String suffix) {
        return Component.translatable((String)(((RedstoneProgrammerBlock)CreateBlocks.REDSTONE_PROGRAMMER.get()).getDescriptionId() + "." + suffix));
    }

    private final void enableScissor(GuiGraphics graphics, Rect2i rect) {
        this.enableScissor(graphics, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    private final void enableScissor(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.enableScissor(this.getGuiLeft() + x, this.getGuiTop() + y, this.getGuiLeft() + x + width, this.getGuiTop() + y + height);
    }
}

