/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.block.multi;

import com.petrolpark.compat.create.core.block.multi.IMultiType;
import com.petrolpark.compat.create.core.block.multi.MultiBehaviour;
import com.petrolpark.util.BlockHelper;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;

public interface IMulti<M extends IMulti<? super M>>
extends INBTSerializable<CompoundTag> {
    public IMultiType<? extends M> getMultiType();

    public Level getLevel();

    public void setLevel(Level var1);

    public void setMultiControllerAbsolutePos(BlockPos var1);

    public BlockPos getMultiControllerAbsolutePos();

    public void setMultiAbsoluteLowerOuterCornerPos(BlockPos var1);

    public BlockPos getMultiAbsoluteLowerOuterCornerPos();

    public void setMultiAbsoluteUpperOuterCornerPos(BlockPos var1);

    public BlockPos getMultiAbsoluteUpperOuterCornerPos();

    default public BlockPos getMultiAbsoluteLowerInnerCornerPos() {
        return this.getMultiAbsoluteLowerOuterCornerPos().offset(BlockHelper.UNIT);
    }

    default public BlockPos getMultiAbsoluteUpperInnerCornerPos() {
        return this.getMultiAbsoluteUpperOuterCornerPos().subtract(BlockHelper.UNIT);
    }

    public void markMultiDisassembling();

    public boolean isMultiDisassembling();

    default public void beforeMultiDisassembly() {
    }

    default public void afterMultiDisassembly() {
    }

    public static <M extends IMulti<? super M>> void disassemble(IMulti<?> multi) {
        if (multi.isMultiDisassembling()) {
            return;
        }
        multi.markMultiDisassembling();
        multi.beforeMultiDisassembly();
        BlockHelper.betweenClosedExcludingEdges(multi.getMultiAbsoluteLowerOuterCornerPos(), multi.getMultiAbsoluteUpperOuterCornerPos()).forEach(pos -> Optional.ofNullable((MultiBehaviour)BlockEntityBehaviour.get((BlockGetter)multi.getLevel(), (BlockPos)pos, multi.getMultiType().getBehaviourType())).ifPresent(MultiBehaviour::multiDisassembled));
        multi.afterMultiDisassembly();
    }

    default public void transform(StructureTransform transform, BlockPos newAbsoluteControllerPos) {
        BlockPos controllerMotion = this.getMultiControllerAbsolutePos().subtract((Vec3i)newAbsoluteControllerPos);
        this.setMultiControllerAbsolutePos(newAbsoluteControllerPos);
        BlockPos upperCornerPosition = transform.apply(this.getMultiAbsoluteUpperOuterCornerPos().offset((Vec3i)controllerMotion));
        BlockPos lowerCornerPosition = transform.apply(this.getMultiAbsoluteLowerOuterCornerPos().offset((Vec3i)controllerMotion));
        BlockPos newUpperCornerPosition = new BlockPos(Math.max(upperCornerPosition.getX(), lowerCornerPosition.getX()), Math.max(upperCornerPosition.getY(), lowerCornerPosition.getY()), Math.max(upperCornerPosition.getZ(), lowerCornerPosition.getZ()));
        BlockPos newLowerCornerPosition = new BlockPos(Math.min(upperCornerPosition.getX(), lowerCornerPosition.getX()), Math.min(upperCornerPosition.getY(), lowerCornerPosition.getY()), Math.min(upperCornerPosition.getZ(), lowerCornerPosition.getZ()));
        this.setMultiAbsoluteUpperOuterCornerPos(newUpperCornerPosition);
        this.setMultiAbsoluteLowerOuterCornerPos(newLowerCornerPosition);
    }
}

