/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.dough;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.compat.create.core.dough.DoughBallItem;
import com.petrolpark.compat.create.core.dough.DoughCut;
import com.petrolpark.compat.create.core.dough.IDough;
import com.petrolpark.util.CodecHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class DoughBall<DOUGH extends IDough<DOUGH>> {
    public static final Codec<DoughBall<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IDough.CODEC.fieldOf("dough").forGetter(DoughBall::getDough), (App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("thickness").forGetter(DoughBall::getThickness), (App)CodecHelper.byteRanged((byte)0, (byte)3).fieldOf("width").forGetter(DoughBall::getWidth), (App)CodecHelper.byteRanged((byte)0, (byte)3).fieldOf("length").forGetter(DoughBall::getLength), (App)Codec.list(CutEntry.CODEC).fieldOf("cuts").forGetter(DoughBall::getCuts)).apply((Applicative)instance, DoughBall::create));
    public static final float THICKNESS_AREA_SCALE = 4.0f;
    public final DOUGH dough;
    protected float thickness = 4.0f;
    protected byte width = 1;
    protected byte length = 1;
    protected List<CutEntry> cuts = new ArrayList<CutEntry>();
    protected int cutTiles = 0;

    private static final DoughBall<?> create(IDough<?> dough, float thickness, byte width, byte length, List<CutEntry> cuts) {
        return new DoughBall(dough, thickness, width, length, cuts);
    }

    public DoughBall(DOUGH dough, float thickness, byte width, byte length, List<CutEntry> cuts) {
        this.dough = dough;
        this.thickness = thickness;
        this.width = width;
        this.length = length;
        this.cuts = cuts;
    }

    @Nullable
    public static DoughBall<?> get(ItemStack stack) {
        if (!(stack.getItem() instanceof DoughBallItem)) {
            return null;
        }
        return null;
    }

    public DOUGH getDough() {
        return this.dough;
    }

    public float getThickness() {
        return this.thickness;
    }

    public byte getWidth() {
        return this.width;
    }

    public byte getLength() {
        return this.length;
    }

    public List<CutEntry> getCuts() {
        return this.cuts;
    }

    public final boolean canBeCut() {
        return this.dough.canBeCut();
    }

    public final boolean hasBeenCut() {
        return this.cutTiles != 0;
    }

    public record CutEntry(Holder<DoughCut> cut, byte x, byte y, Rotation rotation) {
        public static final Codec<CutEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DoughCut.CODEC.fieldOf("cut").forGetter(CutEntry::cut), (App)CodecHelper.byteRanged((byte)0, (byte)3).fieldOf("x").forGetter(CutEntry::x), (App)CodecHelper.byteRanged((byte)0, (byte)3).fieldOf("y").forGetter(CutEntry::y), (App)Rotation.CODEC.fieldOf("rotation").forGetter(CutEntry::rotation)).apply((Applicative)instance, CutEntry::new));
    }
}

