/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.actionrecord.packet.entrant;

import com.petrolpark.core.actionrecord.packet.entrant.AlwaysEnterPacketEntrant;
import com.petrolpark.core.actionrecord.packet.entrant.IVanillaPacketEntrant;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;

public final class SimpleVanillaPacketEntrant<LISTENER extends PacketListener, PACKET extends Packet<LISTENER>>
extends AlwaysEnterPacketEntrant<PACKET>
implements IVanillaPacketEntrant<LISTENER, PACKET> {
    public final PacketType<PACKET> type;
    public final String translationKey;
    private final Function<PACKET, Object[]> translationArgs;
    private final Function<PACKET, Object[]> advancedTranslationArgs;

    public SimpleVanillaPacketEntrant(PacketType<PACKET> type, Function<PACKET, Object[]> translationArgs) {
        this(type, translationArgs, null);
    }

    public SimpleVanillaPacketEntrant(PacketType<PACKET> type, Function<PACKET, Object[]> translationArgs, Function<PACKET, Object[]> advancedTranslationArgs) {
        this.type = type;
        this.translationKey = Util.makeDescriptionId((String)"packet", (ResourceLocation)type.id());
        this.translationArgs = translationArgs;
        this.advancedTranslationArgs = advancedTranslationArgs;
    }

    @Override
    public Component getDescription(PACKET packet) {
        return Component.translatable((String)this.translationKey, (Object[])this.translationArgs.apply(packet));
    }

    @Override
    public Component getAdvancedDescription(PACKET packet) {
        if (this.advancedTranslationArgs == null) {
            return super.getAdvancedDescription(packet);
        }
        return Component.translatable((String)(this.translationKey + ".advanced"), (Object[])ArrayUtils.addAll((Object[])this.translationArgs.apply(packet), (Object[])this.advancedTranslationArgs.apply(packet)));
    }
}

