/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.badge;

import com.petrolpark.PetrolparkRecipeSerializers;
import com.petrolpark.core.badge.BadgeItem;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class BadgeDuplicationRecipe
extends CustomRecipe {
    public BadgeDuplicationRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@Nonnull CraftingInput inv, @Nonnull Level level) {
        ItemStack badge = null;
        ItemStack duplicationStack = null;
        for (ItemStack stack : inv.items()) {
            if (stack.getItem() instanceof BadgeItem && badge == null) {
                badge = stack;
                continue;
            }
            if (duplicationStack == null) {
                duplicationStack = stack;
                continue;
            }
            return false;
        }
        if (badge == null) {
            return false;
        }
        Ingredient duplicationIngredient = ((BadgeItem)badge.getItem()).badge.get().getDuplicationIngredient();
        return duplicationIngredient != null && duplicationIngredient.test(duplicationStack);
    }

    public ItemStack assemble(@Nonnull CraftingInput inv, @Nonnull HolderLookup.Provider registryAccess) {
        for (ItemStack stack : inv.items()) {
            if (!(stack.getItem() instanceof BadgeItem)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<BadgeDuplicationRecipe> getSerializer() {
        return (RecipeSerializer)PetrolparkRecipeSerializers.BADGE_DUPLICATION.get();
    }
}

