/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.badge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkDataComponents;
import com.petrolpark.core.badge.Badge;
import com.petrolpark.util.ItemHelper;
import io.netty.buffer.ByteBuf;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BadgeItem
extends Item {
    protected static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    protected static final Style PRIMARY = Style.EMPTY.withColor(13211468);
    protected static final Style HIGHLIGHT = Style.EMPTY.withColor(15850873);
    public final Supplier<Badge> badge;

    public BadgeItem(Item.Properties properties, Supplier<Badge> badge) {
        super(properties);
        this.badge = badge;
    }

    public static ItemStack of(Player player, Badge badge, Date date) {
        ItemStack stack = new ItemStack((ItemLike)badge.asItem());
        stack.set(PetrolparkDataComponents.BADGE_AWARD, (Object)new BadgeAward(player.getUUID(), date.getTime()));
        return stack;
    }

    public Component getName(@Nonnull ItemStack stack) {
        return this.badge.get().getName();
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag isAdvanced) {
        Badge badge = this.badge.get();
        ItemHelper.getOptional(stack, PetrolparkDataComponents.BADGE_AWARD).ifPresentOrElse(badgeAward -> {
            tooltipComponents.add((Component)badge.getDescription().copy().setStyle(PRIMARY));
            Level level = context.level();
            if (level != null) {
                tooltipComponents.add((Component)Component.translatable((String)"item.petrolpark.badge.awarded", (Object[])new Object[]{Optional.ofNullable(level.getPlayerByUUID(badgeAward.playerUUID())).map(Player::getDisplayName).map(Component::copy).orElse(Component.literal((String)"unknown")).setStyle(HIGHLIGHT), Component.literal((String)df.format(new Date(badgeAward.awardDate()))).setStyle(HIGHLIGHT)}).setStyle(PRIMARY));
            }
        }, () -> tooltipComponents.add((Component)Component.translatable((String)"item.petrolpark.badge.unknown").withStyle(ChatFormatting.GRAY)));
    }

    public ItemStack getCraftingRemainingItem(@Nonnull ItemStack stack) {
        return stack;
    }

    public boolean isFoil(@Nonnull ItemStack pStack) {
        return true;
    }

    public record BadgeAward(UUID playerUUID, long awardDate) {
        public static final Codec<BadgeAward> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("player").forGetter(BadgeAward::playerUUID), (App)Codec.LONG.fieldOf("date").forGetter(BadgeAward::awardDate)).apply((Applicative)instance, BadgeAward::new));
        public static final StreamCodec<ByteBuf, BadgeAward> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, BadgeAward::playerUUID, (StreamCodec)ByteBufCodecs.VAR_LONG, BadgeAward::awardDate, BadgeAward::new);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BadgeAward)) return false;
            BadgeAward award = (BadgeAward)obj;
            if (!this.playerUUID.equals(award.playerUUID)) return false;
            if (this.awardDate != award.awardDate) return false;
            return true;
        }

        @Override
        public final int hashCode() {
            return this.playerUUID.hashCode() ^ (int)this.awardDate;
        }
    }
}

