/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.badge;

import com.petrolpark.PetrolparkRegistrate;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.compat.curios.CuriosSetup;
import com.petrolpark.core.badge.Badge;
import com.petrolpark.core.badge.BadgeItem;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonnullType;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;

public class BadgeRegistrateBuilder<T extends Badge, P>
extends AbstractBuilder<Badge, T, P, BadgeRegistrateBuilder<T, P>> {
    private final NonNullSupplier<T> factory;
    protected ItemEntry<BadgeItem> item;
    protected Supplier<Ingredient> duplicationIngredient;

    public static <T extends Badge, P> BadgeRegistrateBuilder<T, P> create(PetrolparkRegistrate owner, P parent, String name, BuilderCallback callback, NonNullSupplier<T> factory) {
        return new BadgeRegistrateBuilder<T, P>(owner, parent, name, callback, factory);
    }

    public BadgeRegistrateBuilder(PetrolparkRegistrate owner, P parent, String name, BuilderCallback callback, NonNullSupplier<T> factory) {
        super((AbstractRegistrate)owner, parent, name, callback, PetrolparkRegistries.Keys.BADGE);
        this.factory = factory;
        this.duplicationIngredient = () -> Ingredient.EMPTY;
        this.item = ((ItemBuilder)((ItemBuilder)this.getOwner().item("badge/" + this.getName(), p -> new BadgeItem((Item.Properties)p, () -> (Badge)this.getEntry())).properties(p -> p.stacksTo(1)).setData(ProviderType.LANG, (c, p) -> {})).setData(ProviderType.ITEM_MODEL, (c, p) -> {})).register();
        CuriosSetup.BADGES.add(this.item);
    }

    public BadgeRegistrateBuilder<T, P> duplicationIngredient(Supplier<Ingredient> ingredient) {
        this.duplicationIngredient = ingredient;
        return this;
    }

    @NonnullType
    protected T createEntry() {
        Badge badge = (Badge)this.factory.get();
        badge.setId(ResourceLocation.fromNamespaceAndPath((String)this.getOwner().getModid(), (String)this.getName()));
        badge.setBadgeItem(this.item);
        badge.setDuplicationItem(this.duplicationIngredient);
        return (T)badge;
    }

    public static Collection<CraftingRecipe> getExampleDuplicationRecipes() {
        return PetrolparkRegistries.BADGES.stream().map(Badge::getExampleDuplicationRecipe).filter(r -> r != null).toList();
    }
}

