/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.contamination;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.core.contamination.Contaminant;
import com.petrolpark.core.contamination.ItemContamination;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ContaminateHeldItemCommand {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(name -> Component.translatable((String)"commands.petrolpark.contaminate.failed.entity", (Object[])new Object[]{name}));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(name -> Component.translatable((String)"commands.petrolpark.contaminate.failed.itemless", (Object[])new Object[]{name}));
    private static final SimpleCommandExceptionType ERROR_NOTHING_HAPPENED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.petrolpark.contaminate.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"petrolpark").then(((LiteralArgumentBuilder)Commands.literal((String)"contaminate").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"contaminant", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, PetrolparkRegistries.Keys.CONTAMINANT)).executes(ctx -> ContaminateHeldItemCommand.contaminate((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), (Holder<Contaminant>)ResourceArgument.getResource((CommandContext)ctx, (String)"contaminant", PetrolparkRegistries.Keys.CONTAMINANT)))))));
    }

    private static int contaminate(CommandSourceStack source, Collection<? extends Entity> targets, Holder<Contaminant> contaminantHolder) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ItemStack itemStack = livingEntity.getMainHandItem();
                if (!itemStack.isEmpty()) {
                    try {
                        if (!ItemContamination.get(itemStack).contaminate(contaminantHolder)) continue;
                        ++i;
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (targets.size() != 1) continue;
                throw ERROR_NO_ITEM.create((Object)livingEntity.getName().getString());
            }
            if (targets.size() != 1) continue;
            throw ERROR_NOT_LIVING_ENTITY.create((Object)entity.getName().getString());
        }
        if (i == 0) {
            throw ERROR_NOTHING_HAPPENED.create();
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.petrolpark.contaminate.success.single", (Object[])new Object[]{Contaminant.getName(contaminantHolder), ((Entity)targets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.petrolpark.contaminate.success.multiple", (Object[])new Object[]{Contaminant.getName(contaminantHolder), targets.size()}), true);
        }
        return i;
    }
}

