/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.loot.numberprovider;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkNumberProviderTypes;
import com.petrolpark.core.data.IEntityTarget;
import com.petrolpark.core.data.loot.numberprovider.IEstimableNumberProvider;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import com.petrolpark.core.data.loot.numberprovider.entity.EntityNumberProvider;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;

public record ContextEntityNumberProvider(IEntityTarget target, EntityNumberProvider value) implements IEstimableNumberProvider
{
    public static final MapCodec<ContextEntityNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IEntityTarget.CODEC.fieldOf("target").forGetter(ContextEntityNumberProvider::target), (App)EntityNumberProvider.CODEC.fieldOf("value").forGetter(ContextEntityNumberProvider::value)).apply((Applicative)instance, ContextEntityNumberProvider::new));

    public float getFloat(@Nonnull LootContext context) {
        Entity entity = this.target.get(context);
        if (entity != null) {
            return this.value.getFloat(entity, context);
        }
        return 0.0f;
    }

    @Override
    public NumberEstimate getEstimate() {
        return this.value().getEstimate();
    }

    @Override
    public float getMaxFloat(LootContext context) {
        Entity entity = this.target.get(context);
        if (entity != null) {
            return this.value.getMaxFloat(entity, context);
        }
        return 0.0f;
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)PetrolparkNumberProviderTypes.CONTEXT_ENTITY.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Sets.union((Set)this.value.getReferencedContextParams(), Set.of(this.target.getReferencedParam()));
    }
}

