/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.loot.numberprovider;

import com.petrolpark.PetrolparkNumberProviderTypes;
import com.petrolpark.core.data.loot.numberprovider.FunctionNumberProvider;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import java.util.List;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class MaxNumberProvider
extends FunctionNumberProvider {
    public MaxNumberProvider(List<NumberProvider> children) {
        super(children);
    }

    @Override
    public float apply(LootContext lootContext, DoubleStream childResults) {
        return (float)childResults.max().orElse(0.0);
    }

    @Override
    public NumberEstimate applyEstimate(Stream<NumberEstimate> estimates) {
        float min = 0.0f;
        float max = 0.0f;
        boolean approximate = false;
        for (NumberEstimate estimate : estimates.toList()) {
            if (estimate.unknown()) {
                return estimate;
            }
            min = Math.max(min, estimate.min());
            max = Math.max(max, estimate.max());
            approximate |= estimate.approximate;
        }
        return NumberEstimate.ranged(min, max, approximate);
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)PetrolparkNumberProviderTypes.MAX.get();
    }
}

