/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.loot.numberprovider;

import com.petrolpark.PetrolparkNumberProviderTypes;
import com.petrolpark.core.data.loot.numberprovider.FunctionNumberProvider;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import java.util.List;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ProductNumberProvider
extends FunctionNumberProvider {
    public ProductNumberProvider(List<NumberProvider> children) {
        super(children);
    }

    @Override
    public float apply(LootContext lootContext, DoubleStream children) {
        return (float)children.reduce(1.0, (a, b) -> a * b);
    }

    @Override
    public NumberEstimate applyEstimate(Stream<NumberEstimate> estimates) {
        return estimates.reduce(NumberEstimate::multiply).orElse(NumberEstimate.UNKNOWN);
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)PetrolparkNumberProviderTypes.PRODUCT.get();
    }
}

