/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.reward;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkRewardTypes;
import com.petrolpark.core.data.IEntityTarget;
import com.petrolpark.core.data.reward.IReward;
import com.petrolpark.core.data.reward.RewardType;
import com.petrolpark.core.data.reward.entity.IEntityReward;
import com.petrolpark.util.Lang;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record ContextEntityReward(IEntityTarget target, IEntityReward reward) implements IReward
{
    public static final MapCodec<ContextEntityReward> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IEntityTarget.CODEC.optionalFieldOf("target", (Object)IEntityTarget.CONTEXT_THIS).forGetter(ContextEntityReward::target), (App)IEntityReward.CODEC.fieldOf("reward").forGetter(ContextEntityReward::reward)).apply((Applicative)instance, ContextEntityReward::new));
    public static final Codec<ContextEntityReward> INLINE_CODEC = IEntityReward.CODEC.xmap(ContextEntityReward::new, ContextEntityReward::reward);

    public ContextEntityReward(IEntityReward reward) {
        this(IEntityTarget.CONTEXT_THIS, reward);
    }

    @Override
    public final void reward(LootContext context, float multiplier) {
        Entity entity = this.target.get(context);
        if (entity != null) {
            this.reward.reward(entity, context, multiplier);
        }
    }

    @Override
    public RewardType getType() {
        return (RewardType)PetrolparkRewardTypes.CONTEXT_ENTITY.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics) {
        this.reward.render(graphics);
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder builder) {
        builder.add(this.translateSimple(this.target.getName()));
        builder.indent();
        this.reward().addToDescription(builder);
        builder.unindent();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Collections.singleton(this.target.getReferencedParam());
    }
}

