/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.reward.entity;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.core.data.reward.entity.IEntityReward;
import com.petrolpark.util.ItemHelper;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.neoforged.neoforge.common.conditions.ConditionalOps;

public abstract class AbstractGiveItemsEntityReward
implements IEntityReward {
    private final List<LootItemFunction> functions;
    protected final BiFunction<ItemStack, LootContext, ItemStack> compositeFunction;

    protected static <REWARD extends AbstractGiveItemsEntityReward> Products.P1<RecordCodecBuilder.Mu<REWARD>, List<LootItemFunction>> lateItemFunctionsField(RecordCodecBuilder.Instance<REWARD> instance) {
        return instance.group((App)ConditionalOps.decodeListWithElementConditions((Codec)LootItemFunctions.ROOT_CODEC).optionalFieldOf("functions", Collections.emptyList()).forGetter(AbstractGiveItemsEntityReward::getItemFunctions));
    }

    public AbstractGiveItemsEntityReward(List<LootItemFunction> functions) {
        this.functions = functions;
        this.compositeFunction = LootItemFunctions.compose(functions);
    }

    public final List<LootItemFunction> getItemFunctions() {
        return this.functions;
    }

    public abstract Stream<ItemStack> streamStacks(Entity var1, LootContext var2);

    @Override
    public final void reward(Entity entity, LootContext context, float multiplier) {
        ItemHelper.give(entity, this.streamStacks(entity, context).map(stack -> this.compositeFunction.apply((ItemStack)stack, context)).map(this.multiplyAmount(multiplier)));
    }

    private UnaryOperator<ItemStack> multiplyAmount(float multiplier) {
        return stack -> stack.copyWithCount(Math.min(stack.getMaxStackSize(), (int)(multiplier * (float)stack.getCount())));
    }
}

