/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.reward.entity;

import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkRewardTypes;
import com.petrolpark.core.data.reward.entity.EntityRewardType;
import com.petrolpark.core.data.reward.entity.IPlayerReward;
import com.petrolpark.core.data.reward.team.ITeamReward;
import com.petrolpark.core.team.GatherTeamProvidersEvent;
import com.petrolpark.core.team.ITeam;
import com.petrolpark.util.CodecHelper;
import com.petrolpark.util.Lang;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public record AllTeamsPlayerReward(ITeamReward reward) implements IPlayerReward
{
    public static final MapCodec<AllTeamsPlayerReward> CODEC = CodecHelper.singleFieldMap(ITeamReward.CODEC, "reward", AllTeamsPlayerReward::reward, AllTeamsPlayerReward::new);

    @Override
    public void rewardPlayer(Player player, LootContext context, float multiplier) {
        GatherTeamProvidersEvent event = new GatherTeamProvidersEvent(player);
        NeoForge.EVENT_BUS.post((Event)event);
        event.getTeamsUnmodifiable((Level)context.getLevel()).forEach(team -> this.reward.reward((ITeam)team, context, multiplier));
    }

    @Override
    public void render(GuiGraphics graphics) {
        this.reward.render(graphics);
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder builder) {
    }

    @Override
    public EntityRewardType getType() {
        return (EntityRewardType)PetrolparkRewardTypes.ALL_TEAMS.get();
    }
}

