/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.inventory.extended;

import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkAttributes;
import com.petrolpark.PetrolparkFeatureFlags;
import com.petrolpark.PetrolparkTags;
import com.petrolpark.config.PetrolparkConfigs;
import com.petrolpark.core.inventory.extended.ExtraInventorySizeChangePacket;
import com.petrolpark.core.inventory.extended.IExtendedInventoryMenu;
import com.petrolpark.util.EntityHelper;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;

@EventBusSubscriber(modid="petrolpark")
@ApiStatus.Experimental
public class ExtendedInventory
extends Inventory {
    public NonNullList<ItemStack> extraItems = NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[0]);
    private int extraHotbarSlots = 0;

    public static final boolean enabled() {
        if (((Boolean)Petrolpark.runForDist(() -> () -> Minecraft.getInstance().getConnection() == null, () -> () -> false)).booleanValue()) {
            return false;
        }
        return PetrolparkFeatureFlags.EXTENDED_INVENTORY.isEnabled();
    }

    public static final boolean enabled(FeatureFlagSet flagSet) {
        return PetrolparkFeatureFlags.EXTENDED_INVENTORY.isEnabled(flagSet);
    }

    public ExtendedInventory(Player player) {
        super(player);
        this.updateSize();
    }

    public static Optional<ExtendedInventory> get(Player player) {
        Optional<ExtendedInventory> optional;
        Inventory inventory = player.getInventory();
        if (inventory instanceof ExtendedInventory) {
            ExtendedInventory extendedInv = (ExtendedInventory)inventory;
            optional = Optional.of(extendedInv);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public void updateSize() {
        this.updateSize(false);
    }

    public void updateSize(boolean forceSync) {
        Player player;
        int sizeBefore = this.extraItems.size();
        int hotbarBefore = this.extraHotbarSlots;
        if (this.player.getAttributes().hasAttribute(PetrolparkAttributes.EXTRA_HOTBAR_SLOTS.getDelegate())) {
            this.setExtraHotbarSlots((int)this.player.getAttributeValue(PetrolparkAttributes.EXTRA_HOTBAR_SLOTS.getDelegate()));
        }
        if (this.player.getAttributes().hasAttribute(PetrolparkAttributes.EXTRA_INVENTORY_SIZE.getDelegate())) {
            this.setExtraInventorySize((int)this.player.getAttributeValue(PetrolparkAttributes.EXTRA_INVENTORY_SIZE.getDelegate()));
        }
        if ((forceSync || sizeBefore != this.extraItems.size() || hotbarBefore != this.extraHotbarSlots) && !this.player.level().isClientSide() && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (sp.connection != null) {
                this.player.closeContainer();
                CatnipServices.NETWORK.sendToClient(sp, (CustomPacketPayload)new ExtraInventorySizeChangePacket(this.extraItems.size(), this.extraHotbarSlots, false));
                ExtendedInventory.refreshPlayerInventoryMenuServer((Player)sp);
            }
        }
    }

    public static void refreshPlayerInventoryMenu(Player player, int columns, int invX, int invY, int leftHotbarSlots, int leftHotbarX, int leftHotbarY, int rightHotbarX, int rightHotbarY) {
        InventoryMenu newMenu;
        InventoryMenu oldMenu = player.inventoryMenu;
        player.inventoryMenu = newMenu = new InventoryMenu(player.getInventory(), !player.level().isClientSide(), player);
        ExtendedInventory.get(player).ifPresent(inv -> inv.addExtraInventorySlotsToMenu((AbstractContainerMenu)player.inventoryMenu, columns, invX, invY, leftHotbarSlots, leftHotbarX, leftHotbarY, rightHotbarX, rightHotbarY));
        player.containerMenu = player.inventoryMenu;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (sp.containerSynchronizer != null && sp.containerListener != null) {
                sp.initInventoryMenu();
            }
        }
        newMenu.containerListeners.addAll(oldMenu.containerListeners);
    }

    public static void refreshPlayerInventoryMenuServer(Player player) {
        ExtendedInventory.refreshPlayerInventoryMenu(player, 5, 0, 0, 0, 0, 0, 0, 0);
    }

    public static boolean isVanillaHotbarSlot(int index) {
        return Inventory.isHotbarSlot((int)index);
    }

    public void setExtraInventorySize(int size) {
        if ((size = Math.max(size, 0)) == this.extraItems.size()) {
            return;
        }
        if (size < this.extraItems.size()) {
            for (int stack = size; stack < this.extraItems.size(); ++stack) {
                this.placeItemBackInInventory((ItemStack)this.extraItems.get(stack), true);
            }
        }
        NonNullList newExtraItems = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        for (int i = 0; i < size && i < this.extraItems.size(); ++i) {
            newExtraItems.set(i, (Object)((ItemStack)this.extraItems.get(i)));
        }
        this.extraItems = newExtraItems;
        this.setChanged();
    }

    public void setExtraHotbarSlots(int extraSlots) {
        if ((extraSlots = Math.max(extraSlots, 0)) == this.extraHotbarSlots) {
            return;
        }
        this.extraHotbarSlots = extraSlots;
        this.setChanged();
    }

    public int getExtraHotbarSlots() {
        return Math.min(this.extraItems.size(), this.extraHotbarSlots);
    }

    public int getExtraInventoryStartSlotIndex() {
        return super.getContainerSize();
    }

    public boolean isFullHotbarSlot(int index) {
        int extraInventoryStart = this.getExtraInventoryStartSlotIndex();
        return ExtendedInventory.isVanillaHotbarSlot(index) || index >= extraInventoryStart && index - extraInventoryStart < this.getExtraHotbarSlots();
    }

    public int getHotbarSize() {
        return ExtendedInventory.getSelectionSize() + this.getExtraHotbarSlots();
    }

    protected int getSlotIndex(int hotbarIndex) {
        if (hotbarIndex < 0 || hotbarIndex >= this.getHotbarSize()) {
            return -1;
        }
        if (hotbarIndex < 9) {
            return hotbarIndex;
        }
        return this.getExtraInventoryStartSlotIndex() + hotbarIndex - ExtendedInventory.getSelectionSize();
    }

    public int getSelectedHotbarIndex() {
        if (ExtendedInventory.isVanillaHotbarSlot(this.selected)) {
            return this.selected;
        }
        return this.selected - this.getExtraInventoryStartSlotIndex() + ExtendedInventory.getSelectionSize();
    }

    @SubscribeEvent
    public static void onPlayerJoinsWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (!ExtendedInventory.enabled(event.getEntity().level().enabledFeatures())) {
            return;
        }
        ExtendedInventory.refreshPlayerInventoryMenuServer(event.getEntity());
        Optional<ExtendedInventory> invOp = ExtendedInventory.get(event.getEntity());
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (invOp.isPresent()) {
                CatnipServices.NETWORK.sendToClient(player2, (CustomPacketPayload)new ExtraInventorySizeChangePacket(invOp.get().extraItems.size(), invOp.get().extraHotbarSlots, true));
            }
        }
    }

    @SubscribeEvent
    public static void onOpenContainer(PlayerContainerEvent.Open event) {
        if (!ExtendedInventory.enabled()) {
            return;
        }
        AbstractContainerMenu menu = event.getContainer();
        if (!ExtendedInventory.supportsExtraInventory(menu) || menu instanceof IExtendedInventoryMenu) {
            return;
        }
        ExtendedInventory.get(event.getEntity()).ifPresent(inv -> inv.addExtraInventorySlotsToMenu(menu, 5, 0, 0, 0, 0, 0, 0, 0));
    }

    public static boolean supportsExtraInventory(AbstractContainerMenu menu) {
        if (menu instanceof IExtendedInventoryMenu) {
            return true;
        }
        try {
            MenuType menuType = menu.getType();
            if (menuType == null) {
                return false;
            }
            if (((Boolean)PetrolparkConfigs.server().extendedInventorySafeMode.get()).booleanValue()) {
                return PetrolparkTags.MenuTypes.ALWAYS_SHOWS_EXTENDED_INVENTORY.matches(menuType);
            }
            return !PetrolparkTags.MenuTypes.NEVER_SHOWS_EXTENDED_INVENTORY.matches(menuType);
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    public void addExtraInventorySlotsToMenu(AbstractContainerMenu menu, int columns, int invX, int invY, int leftHotbarSlots, int leftHotbarX, int leftHotbarY, int rightHotbarX, int rightHotbarY) {
        this.addExtraInventorySlotsToMenu(arg_0 -> ((AbstractContainerMenu)menu).addSlot(arg_0), Slot::new, columns, invX, invY, leftHotbarSlots, leftHotbarX, leftHotbarY, rightHotbarX, rightHotbarY);
    }

    public void addExtraInventorySlotsToMenu(Consumer<Slot> slotAdder, SlotFactory slotFactory, int columns, int invX, int invY, int leftHotbarSlots, int leftHotbarX, int leftHotbarY, int rightHotbarX, int rightHotbarY) {
        int i;
        int extraItemsStart = this.getExtraInventoryStartSlotIndex();
        for (int i2 = 0; i2 < this.getExtraHotbarSlots() - leftHotbarSlots; ++i2) {
            slotAdder.accept(slotFactory.create((Container)this, extraItemsStart + i2, rightHotbarX + i2 * 18, rightHotbarY));
        }
        int j = 0;
        for (i = this.getExtraHotbarSlots() - leftHotbarSlots; i < this.getExtraHotbarSlots(); ++i) {
            slotAdder.accept(slotFactory.create((Container)this, extraItemsStart + i, leftHotbarX + j * 18, leftHotbarY));
            ++j;
        }
        j = 0;
        for (i = this.getExtraHotbarSlots(); i < this.extraItems.size(); ++i) {
            slotAdder.accept(slotFactory.create((Container)this, extraItemsStart + i, invX + 18 * (j % columns), invY + 18 * (j / columns)));
            ++j;
        }
    }

    public void forEach(Consumer<? super ItemStack> action) {
        this.items.forEach(action);
        this.armor.forEach(action);
        this.offhand.forEach(action);
        this.extraItems.forEach(action);
    }

    public Stream<ItemStack> stream() {
        return Stream.concat(Stream.concat(this.items.stream(), this.armor.stream()), Stream.concat(this.offhand.stream(), this.extraItems.stream()));
    }

    public ItemStack getSelected() {
        int selectedExtra;
        int extraInventoryStart = this.getExtraInventoryStartSlotIndex();
        if (this.selected >= extraInventoryStart && (selectedExtra = this.selected - extraInventoryStart) < this.getExtraHotbarSlots()) {
            return (ItemStack)this.extraItems.get(selectedExtra);
        }
        return super.getSelected();
    }

    public int getFreeSlot() {
        int freeSlot = super.getFreeSlot();
        if (freeSlot == -1) {
            for (int i = 0; i < this.extraItems.size(); ++i) {
                if (!((ItemStack)this.extraItems.get(i)).isEmpty()) continue;
                return this.getExtraInventoryStartSlotIndex() + i;
            }
            return -1;
        }
        return freeSlot;
    }

    public void setPickedItem(@Nonnull ItemStack stack) {
        int matchingSlot = this.findSlotMatchingItem(stack);
        if (this.isFullHotbarSlot(matchingSlot)) {
            this.selected = matchingSlot;
        } else if (matchingSlot != -1) {
            this.pickSlot(matchingSlot);
        } else {
            int freeSlot;
            this.selected = this.getSuitableHotbarSlot();
            if (!this.getItem(this.selected).isEmpty() && (freeSlot = this.getFreeSlot()) != -1) {
                this.setItem(freeSlot, stack);
            }
            this.setItem(this.selected, stack);
        }
    }

    public void pickSlot(int index) {
        this.selected = this.getSuitableHotbarSlot();
        ItemStack oldSelectedStack = this.getItem(this.selected);
        this.setItem(this.selected, this.getItem(index));
        this.setItem(index, oldSelectedStack);
    }

    public int findSlotMatchingItem(@Nonnull ItemStack stack) {
        return this.findSlot(s -> !s.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)stack));
    }

    public int findSlotMatchingUnusedItem(@Nonnull ItemStack stack) {
        return this.findSlot(s -> !s.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)stack) && !s.isDamaged() && !s.isEnchanted() && !s.has(DataComponents.CUSTOM_NAME));
    }

    public int findSlot(Predicate<ItemStack> stackPredicate) {
        int i;
        for (i = 0; i < this.items.size(); ++i) {
            if (!stackPredicate.test((ItemStack)this.items.get(i))) continue;
            return i;
        }
        for (i = 0; i < this.extraItems.size(); ++i) {
            if (!stackPredicate.test((ItemStack)this.extraItems.get(i))) continue;
            return this.getExtraInventoryStartSlotIndex() + i;
        }
        return -1;
    }

    public int getSuitableHotbarSlot() {
        int nextSlot;
        int i;
        int selectedHotbarSlot = this.getSelectedHotbarIndex();
        for (i = 0; i < this.getHotbarSize(); ++i) {
            nextSlot = this.getSlotIndex((selectedHotbarSlot + i) % this.getHotbarSize());
            if (!this.getItem(nextSlot).isEmpty()) continue;
            return nextSlot;
        }
        for (i = 0; i < this.getHotbarSize(); ++i) {
            nextSlot = this.getSlotIndex((selectedHotbarSlot + i) % this.getHotbarSize());
            if (this.getItem(nextSlot).isNotReplaceableByPickAction(this.player, nextSlot)) continue;
            return nextSlot;
        }
        return -1;
    }

    public void swapPaint(double scroll) {
        int d = (int)Math.signum(scroll);
        int selectedHotbarSlot = this.getSelectedHotbarIndex();
        selectedHotbarSlot -= d;
        while (selectedHotbarSlot < 0) {
            selectedHotbarSlot += this.getHotbarSize();
        }
        while (selectedHotbarSlot >= this.getHotbarSize()) {
            selectedHotbarSlot -= this.getHotbarSize();
        }
        this.selected = this.getSlotIndex(selectedHotbarSlot);
    }

    public int getSlotWithRemainingSpace(@Nonnull ItemStack stack) {
        int slot = super.getSlotWithRemainingSpace(stack);
        if (slot == -1) {
            for (int i = 0; i < this.extraItems.size(); ++i) {
                if (!this.hasRemainingSpaceForItem((ItemStack)this.extraItems.get(i), stack)) continue;
                return this.getExtraInventoryStartSlotIndex() + i;
            }
        }
        return slot;
    }

    public void tick() {
        this.updateSize();
        super.tick();
        for (int i = 0; i < this.extraItems.size(); ++i) {
            int slot = this.getExtraInventoryStartSlotIndex() + i;
            ((ItemStack)this.extraItems.get(i)).inventoryTick(this.player.level(), (Entity)this.player, slot, this.selected == slot);
        }
    }

    public boolean add(int slot, @Nonnull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        try {
            int count;
            if (stack.isDamaged()) {
                if (slot == -1) {
                    slot = this.getFreeSlot();
                }
                if (slot >= this.getExtraInventoryStartSlotIndex()) {
                    int extraItemsIndex = slot - this.getExtraInventoryStartSlotIndex();
                    this.extraItems.set(extraItemsIndex, (Object)stack.copyAndClear());
                    ((ItemStack)this.extraItems.get(extraItemsIndex)).setPopTime(5);
                    return true;
                }
                if (slot >= 0) {
                    this.items.set(slot, (Object)stack.copyAndClear());
                    ((ItemStack)this.items.get(slot)).setPopTime(5);
                    return true;
                }
                if (this.player.getAbilities().instabuild) {
                    stack.setCount(0);
                    return true;
                }
                return false;
            }
            do {
                count = stack.getCount();
                if (slot == -1) {
                    stack.setCount(this.addResource(stack));
                    continue;
                }
                stack.setCount(this.addResource(slot, stack));
            } while (!stack.isEmpty() && stack.getCount() < count);
            if (stack.getCount() == count && this.player.getAbilities().instabuild) {
                stack.setCount(0);
                return true;
            }
            return stack.getCount() < count;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Adding item to inventory");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Item being added");
            crashreportcategory.setDetail("Registry Name", () -> String.valueOf(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())));
            crashreportcategory.setDetail("Item Class", () -> stack.getItem().getClass().getName());
            crashreportcategory.setDetail("Item ID", (Object)Item.getId((Item)stack.getItem()));
            crashreportcategory.setDetail("Item data", (Object)stack.getDamageValue());
            crashreportcategory.setDetail("Item name", () -> stack.getHoverName().getString());
            throw new ReportedException(crashreport);
        }
    }

    public ItemStack removeItem(int slotIndex, int count) {
        if (slotIndex >= this.getExtraInventoryStartSlotIndex() && (slotIndex -= this.getExtraInventoryStartSlotIndex()) < this.extraItems.size()) {
            if (((ItemStack)this.extraItems.get(slotIndex)).isEmpty()) {
                return ItemStack.EMPTY;
            }
            return ContainerHelper.removeItem(this.extraItems, (int)slotIndex, (int)count);
        }
        return super.removeItem(slotIndex, count);
    }

    public void removeItem(@Nonnull ItemStack stack) {
        if (!this.extraItems.removeIf(s -> s == stack)) {
            super.removeItem(stack);
        }
    }

    public ItemStack removeItemNoUpdate(int slotIndex) {
        if (slotIndex >= this.getExtraInventoryStartSlotIndex() && (slotIndex -= this.getExtraInventoryStartSlotIndex()) < this.extraItems.size()) {
            ItemStack stack = (ItemStack)this.extraItems.get(slotIndex);
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            this.extraItems.set(slotIndex, (Object)ItemStack.EMPTY);
            return stack;
        }
        return super.removeItemNoUpdate(slotIndex);
    }

    public void setItem(int slotIndex, @Nonnull ItemStack stack) {
        if (slotIndex >= this.getExtraInventoryStartSlotIndex() && (slotIndex -= this.getExtraInventoryStartSlotIndex()) < this.extraItems.size()) {
            this.extraItems.set(slotIndex, (Object)stack);
            return;
        }
        super.setItem(slotIndex, stack);
    }

    public float getDestroySpeed(@Nonnull BlockState state) {
        return this.getItem(this.selected).getDestroySpeed(state);
    }

    public ListTag save(@Nonnull ListTag listTag) {
        listTag = super.save(listTag);
        int extraInventoryStart = this.getExtraInventoryStartSlotIndex();
        for (int i = 0; i < this.extraItems.size(); ++i) {
            ItemStack stack = (ItemStack)this.extraItems.get(i);
            if (stack.isEmpty()) continue;
            CompoundTag tag = new CompoundTag();
            tag.putByte("Slot", (byte)(i + extraInventoryStart));
            listTag.add((Object)stack.save((HolderLookup.Provider)this.player.registryAccess(), (Tag)tag));
        }
        return listTag;
    }

    public void load(@Nonnull ListTag listTag) {
        super.load(listTag);
        EntityHelper.refreshEquipmentAttributeModifiers((LivingEntity)this.player);
        this.updateSize();
        int extraInventoryStart = this.getExtraInventoryStartSlotIndex();
        for (int i = 0; i < listTag.size(); ++i) {
            int slotIndex;
            CompoundTag tag = listTag.getCompound(i);
            if (!tag.contains("Slot", 1) || (slotIndex = tag.getByte("Slot") & 0xFF) < extraInventoryStart || (slotIndex -= extraInventoryStart) >= this.extraItems.size()) continue;
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)this.player.registryAccess(), (Tag)tag).orElse(ItemStack.EMPTY);
            this.extraItems.set(slotIndex, (Object)stack);
        }
    }

    public int getContainerSize() {
        return super.getContainerSize() + this.extraItems.size();
    }

    public boolean isEmpty() {
        return super.isEmpty() && !this.extraItems.stream().anyMatch(stack -> !stack.isEmpty());
    }

    public ItemStack getItem(int slotIndex) {
        int extraInventoryStart = this.getExtraInventoryStartSlotIndex();
        if (slotIndex >= extraInventoryStart && (slotIndex -= extraInventoryStart) < this.extraItems.size()) {
            return (ItemStack)this.extraItems.get(slotIndex);
        }
        return super.getItem(slotIndex);
    }

    public void dropAll() {
        super.dropAll();
        for (int i = 0; i < this.extraItems.size(); ++i) {
            ItemStack stack = (ItemStack)this.extraItems.get(i);
            if (stack.isEmpty()) continue;
            this.player.drop(stack, true, false);
            this.extraItems.set(i, (Object)ItemStack.EMPTY);
        }
    }

    public boolean contains(@Nonnull ItemStack stack) {
        return this.findSlot(s -> ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)stack)) != -1;
    }

    public boolean contains(@Nonnull TagKey<Item> tag) {
        return this.findSlot(s -> s.is(tag)) != -1;
    }

    public void replaceWith(@Nonnull Inventory playerInventory) {
        if (playerInventory instanceof ExtendedInventory) {
            ExtendedInventory extendedInv = (ExtendedInventory)playerInventory;
            this.setExtraHotbarSlots(extendedInv.extraHotbarSlots);
            this.setExtraInventorySize(extendedInv.extraItems.size());
        }
        super.replaceWith(playerInventory);
    }

    public void clearContent() {
        super.clearContent();
        this.extraItems.clear();
    }

    public void fillStackedContents(@Nonnull StackedContents stackedContents) {
        super.fillStackedContents(stackedContents);
        this.extraItems.forEach(arg_0 -> ((StackedContents)stackedContents).accountSimpleStack(arg_0));
    }

    @FunctionalInterface
    public static interface SlotFactory {
        public Slot create(Container var1, int var2, int var3, int var4);
    }

    public static interface DelayedSlotPopulation {
        public void populateDelayedSlots();
    }
}

