/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.item.decay;

import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkDataComponents;
import com.petrolpark.core.item.decay.DecayTime;
import com.petrolpark.core.item.decay.product.IDecayProduct;
import com.petrolpark.core.item.decay.product.NoDecayProduct;
import com.petrolpark.util.DataComponentHelper;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public interface ItemDecay {
    public static long getGameTime() {
        return (Long)Petrolpark.runForDist(() -> () -> {
            Minecraft mc = Minecraft.getInstance();
            ClientLevel level = mc.level;
            if (level == null) {
                return 0L;
            }
            return level.getGameTime();
        }, () -> () -> ((ServerLevel)ServerLifecycleHooks.getCurrentServer().overworld()).getGameTime());
    }

    public static ItemStack checkDecay(ItemStack stack) {
        return ItemDecay.checkDecay(stack, s -> s);
    }

    public static ItemStack checkDecay(ItemStack stack, UnaryOperator<ItemStack> newDecay) {
        long timeDead;
        if (stack.isEmpty()) {
            return stack;
        }
        if (!stack.has(PetrolparkDataComponents.DECAY_TIME) || !stack.has(PetrolparkDataComponents.DECAY_PRODUCT)) {
            return stack;
        }
        Long creationTime = (Long)stack.get(PetrolparkDataComponents.DECAY_START_TIME);
        if (creationTime != null && (timeDead = -ItemDecay.getRemainingTime(stack, (long)creationTime)) >= 0L) {
            ItemStack copy = ItemDecay.copyIgnoringDecay(stack);
            ItemDecay.removeAppliedDecay(copy);
            ItemStack product = ((IDecayProduct)stack.getOrDefault(PetrolparkDataComponents.DECAY_PRODUCT, (Object)NoDecayProduct.INSTANCE)).get(copy);
            product.setCount(stack.getCount());
            product = (ItemStack)newDecay.apply(product);
            ItemDecay.startDecay(product, timeDead);
            return ItemDecay.checkDecay(product, newDecay);
        }
        return stack;
    }

    public static ItemStack copyIgnoringDecay(ItemStack stack) {
        ItemStack copy = new ItemStack(stack.getItemHolder(), stack.getCount(), stack.getComponentsPatch());
        copy.setPopTime(stack.getPopTime());
        return copy;
    }

    public static ItemStack removeAppliedDecay(ItemStack stack) {
        stack.remove(PetrolparkDataComponents.DECAY_START_TIME);
        DataComponentHelper.revert(stack, PetrolparkDataComponents.DECAY_PRODUCT);
        DataComponentHelper.revert(stack, PetrolparkDataComponents.DECAY_TIME);
        return stack;
    }

    public static long getLifetimeOrNone(ItemStack stack) {
        return ((DecayTime)stack.getOrDefault(PetrolparkDataComponents.DECAY_TIME, (Object)DecayTime.NONE)).lifetime();
    }

    public static long getRemainingTime(ItemStack decayingItemStack, long creationTime) {
        return ItemDecay.getRemainingTime(((DecayTime)decayingItemStack.getOrDefault(PetrolparkDataComponents.DECAY_TIME, (Object)DecayTime.NONE)).lifetime(), creationTime);
    }

    public static long getRemainingTime(long lifetime, long creationTime) {
        return lifetime + creationTime - ItemDecay.getGameTime();
    }

    public static void startDecay(ItemStack stack) {
        ItemDecay.startDecay(stack, 0L);
    }

    public static void startDecay(ItemStack stack, long timeElapsed) {
        if (stack.has(PetrolparkDataComponents.DECAY_PRODUCT) && stack.has(PetrolparkDataComponents.DECAY_TIME) && !stack.has(PetrolparkDataComponents.DECAY_START_TIME)) {
            stack.set(PetrolparkDataComponents.DECAY_START_TIME, (Object)(ItemDecay.getGameTime() - timeElapsed));
        }
    }

    public static void extendLifetime(ItemStack decayingItemStack, int additionalLifetime) {
        if (decayingItemStack.has(PetrolparkDataComponents.DECAY_TIME)) {
            Long creationTime = (Long)decayingItemStack.get(PetrolparkDataComponents.DECAY_START_TIME);
            if (creationTime == null) {
                return;
            }
            long remainingTime = ItemDecay.getRemainingTime(decayingItemStack, (long)creationTime);
            long newLifetime = Math.max(0L, (long)additionalLifetime + remainingTime);
            decayingItemStack.set(PetrolparkDataComponents.DECAY_START_TIME, (Object)(ItemDecay.getGameTime() + newLifetime - ItemDecay.getLifetimeOrNone(decayingItemStack)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<Component> getTooltip(ItemStack stack) {
        return Optional.ofNullable((DecayTime)stack.get(PetrolparkDataComponents.DECAY_TIME)).map(decayTime -> {
            long displayedSecondsRemaining;
            Long creationTime = (Long)stack.get(PetrolparkDataComponents.DECAY_START_TIME);
            if (creationTime != null) {
                long ticksRemaining = ItemDecay.getRemainingTime(decayTime.lifetime(), (long)creationTime);
                displayedSecondsRemaining = ticksRemaining / 20L;
            } else {
                displayedSecondsRemaining = decayTime.lifetime() / 20L;
            }
            if (displayedSecondsRemaining < 0L) {
                displayedSecondsRemaining = 0L;
            }
            return Component.translatable((String)decayTime.translationKey(), (Object[])new Object[]{String.format("%02d:%02d", displayedSecondsRemaining / 60L, displayedSecondsRemaining % 60L)}).copy().withStyle(ChatFormatting.GRAY);
        });
    }
}

