/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe;

import com.petrolpark.util.Lang;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public interface INamedRecipe {
    public static final String UNKNOWN_RECIPE_TRANSLATION_KEY = "recipe.petrolpark.unknown";

    public static Component unknownRecipeName() {
        return Component.translatable((String)UNKNOWN_RECIPE_TRANSLATION_KEY);
    }

    public static Component getName(RecipeHolder<?> recipeHolder) {
        Recipe recipe = recipeHolder.value();
        if (recipe instanceof INamedRecipe) {
            INamedRecipe namedRecipe = (INamedRecipe)recipe;
            return namedRecipe.getName(recipeHolder.id());
        }
        try {
            ItemStack stack = recipe.getResultItem(null);
            if (!stack.isEmpty()) {
                return stack.getHoverName();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return INamedRecipe.unknownRecipeName();
    }

    public Component getName(ResourceLocation var1);

    public static Component cacheDefaultName(Component cachedName, Consumer<Component> cachedNameSetter, ResourceLocation recipeId, Supplier<List<Component>> outputNames) {
        if (cachedName == null) {
            String translationKey = Util.makeDescriptionId((String)"recipe", (ResourceLocation)recipeId);
            cachedName = I18n.exists((String)translationKey) ? Component.translatable((String)translationKey) : Lang.shortList(outputNames.get(), 150);
            cachedNameSetter.accept((Component)cachedName);
        }
        return cachedName;
    }
}

