/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.bogglepattern;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.Rotation;

public class BogglePatternHelper {
    public static final Codec<Integer> SHORT_CODEC = Codec.SHORT.xmap(BogglePatternHelper::fromShort, BogglePatternHelper::asShort);
    public static final StreamCodec<ByteBuf, Integer> SHORT_STREAM_CODEC = ByteBufCodecs.SHORT.map(BogglePatternHelper::fromShort, BogglePatternHelper::asShort);
    public static final int[] ROTATED_90 = new int[]{3, 7, 11, 15, 2, 6, 10, 14, 1, 5, 9, 13, 0, 4, 8, 12};
    public static final int[] ROTATED_270 = new int[]{12, 8, 4, 0, 13, 9, 5, 1, 14, 10, 6, 2, 15, 11, 7, 3};
    public static final int[] FLIPPED = new int[]{3, 2, 1, 0, 7, 6, 5, 4, 11, 10, 9, 8, 15, 14, 13, 12};

    public static final int set1(int binaryMatrix, int index) {
        return binaryMatrix | 1 << index;
    }

    public static final int set1(int binaryMatrix, int x, int y) {
        return BogglePatternHelper.set1(binaryMatrix, BogglePatternHelper.getIndex(x, y));
    }

    public static final boolean is1(int binaryMatrix, int x, int y) {
        return BogglePatternHelper.is1(binaryMatrix, BogglePatternHelper.getIndex(x, y));
    }

    public static final boolean is1(int binaryMatrix, int index) {
        BogglePatternHelper.validateIndex(index);
        return (binaryMatrix & 1 << index) != 0;
    }

    public static final int getIndex(int x, int y) {
        return x + 4 * y;
    }

    public static final int rotate(int index, Rotation rotation) {
        BogglePatternHelper.validateIndex(index);
        for (int i = 0; i < rotation.ordinal(); ++i) {
            index = ROTATED_270[index];
        }
        return index;
    }

    public static final int flip(int index) {
        BogglePatternHelper.validateIndex(index);
        return FLIPPED[index];
    }

    public static final int rotateMatrix(int binaryMatrix, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            binaryMatrix = (binaryMatrix & 1) << 12 | (binaryMatrix & 2) << 8 | (binaryMatrix & 4) << 4 | (binaryMatrix & 8) << 0 | (binaryMatrix & 0x10) << 8 | (binaryMatrix & 0x20) << 4 | (binaryMatrix & 0x40) << 0 | (binaryMatrix & 0x80) >> 4 | (binaryMatrix & 0x100) << 4 | (binaryMatrix & 0x200) << 0 | (binaryMatrix & 0x400) >> 4 | (binaryMatrix & 0x800) >> 8 | (binaryMatrix & 0x1000) << 0 | (binaryMatrix & 0x2000) >> 4 | (binaryMatrix & 0x4000) >> 8 | (binaryMatrix & 0x8000) >> 12;
        }
        return binaryMatrix;
    }

    public static final int getWidth(int binaryMatrix) {
        if (binaryMatrix == 0) {
            return 0;
        }
        for (int x = 3; x >= 1; --x) {
            for (int y = 0; y < 4; ++y) {
                if (!BogglePatternHelper.is1(binaryMatrix, x, y)) continue;
                return x;
            }
        }
        return 0;
    }

    public static final int getHeight(int binaryMatrix) {
        if (binaryMatrix == 0) {
            return 0;
        }
        for (int y = 3; y >= 1; --y) {
            for (int x = 0; x < 4; ++x) {
                if (!BogglePatternHelper.is1(binaryMatrix, x, y)) continue;
                return y;
            }
        }
        return 0;
    }

    public static final void validateIndex(int index) {
        if (index < 0 || index >= 16) {
            throw new IllegalArgumentException("Indices in a 4x4 binary matrix go from 0 to 15");
        }
    }

    public static final short asShort(int binaryMatrix) {
        return (short)(binaryMatrix - Short.MAX_VALUE);
    }

    public static final int fromShort(short binaryMatrixShort) {
        return Short.MAX_VALUE + binaryMatrixShort;
    }

    public static final String[] format(int bogglePattern) {
        String[] lines = new String[4];
        for (int row = 0; row < 4; ++row) {
            Object line = "";
            for (int column = 0; column < 4; ++column) {
                line = (String)line + (BogglePatternHelper.is1(bogglePattern, column, row) ? "\u2588" : "\u2592");
            }
            lines[row] = line;
        }
        return lines;
    }
}

