/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.book;

import com.petrolpark.core.recipe.INamedRecipe;
import com.petrolpark.core.recipe.book.IRecipeBookAcceptorBlock;
import com.petrolpark.core.recipe.book.IRecipeBookAcceptorBlockEntity;
import com.petrolpark.core.recipe.book.IRecipeBookProviderBlock;
import com.petrolpark.util.LinkedHashSetQueue;
import java.util.HashSet;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IBookRequiredRecipe
extends INamedRecipe {
    public boolean isBookRequired(Level var1);

    @Nullable
    public static IBookRequiredRecipe checkedCast(Recipe<?> recipe) {
        IBookRequiredRecipe bnr;
        return recipe instanceof IBookRequiredRecipe ? (bnr = (IBookRequiredRecipe)recipe) : null;
    }

    public static boolean hasRequiredBook(BlockEntity be, RecipeHolder<?> recipeHolder) {
        return IBookRequiredRecipe.hasRequiredBook(be.getLevel(), be.getBlockPos(), recipeHolder);
    }

    public static boolean hasRequiredBook(Level level, BlockPos pos, RecipeHolder<?> recipeHolder) {
        LinkedHashSetQueue acceptorPositions = new LinkedHashSetQueue();
        HashSet<BlockPos> checkedAcceptorPositions = new HashSet<BlockPos>();
        acceptorPositions.add(pos);
        while (!acceptorPositions.isEmpty()) {
            BlockState acceptorState;
            BlockPos acceptorPos = (BlockPos)acceptorPositions.poll();
            if (!IBookRequiredRecipe.isRecipeBookAcceptor(level, acceptorPos, acceptorState = level.getBlockState(acceptorPos)) || !checkedAcceptorPositions.add(acceptorPos)) continue;
            for (Direction face : Direction.values()) {
                IRecipeBookProviderBlock rbpBlock;
                BlockPos providerPos = acceptorPos.relative(face);
                BlockState providerState = level.getBlockState(providerPos);
                Block block = providerState.getBlock();
                if (!(block instanceof IRecipeBookProviderBlock) || !(rbpBlock = (IRecipeBookProviderBlock)block).providesRecipeBook(recipeHolder, level, providerPos, providerState)) continue;
                return true;
            }
            IBookRequiredRecipe.addProxyRecipeBookAcceptorPositions(level, acceptorPos, acceptorState, acceptorPositions::add);
        }
        return false;
    }

    public static boolean isRecipeBookAcceptor(Level level, BlockPos pos, BlockState state) {
        return state.getBlock() instanceof IRecipeBookAcceptorBlock || level.getBlockEntity(pos) instanceof IRecipeBookAcceptorBlockEntity;
    }

    public static boolean acceptsRecipe(Level level, BlockPos pos, BlockState state, RecipeHolder<?> recipeHolder) {
        IRecipeBookAcceptorBlockEntity rbaBlockEntity;
        IRecipeBookAcceptorBlock rbaBlock;
        Block block = state.getBlock();
        if (block instanceof IRecipeBookAcceptorBlock && (rbaBlock = (IRecipeBookAcceptorBlock)block).acceptsRecipeBook(level, pos, state, recipeHolder)) {
            return true;
        }
        block = level.getBlockEntity(pos);
        return block instanceof IRecipeBookAcceptorBlockEntity && (rbaBlockEntity = (IRecipeBookAcceptorBlockEntity)block).acceptsRecipeBook(recipeHolder);
    }

    public static void addProxyRecipeBookAcceptorPositions(Level level, BlockPos acceptorPos, BlockState acceptorState, Consumer<BlockPos> posAdder) {
        Block block = acceptorState.getBlock();
        if (block instanceof IRecipeBookAcceptorBlock) {
            IRecipeBookAcceptorBlock rbaBlock = (IRecipeBookAcceptorBlock)block;
            rbaBlock.addProxyRecipeBookAcceptorPositions(level, acceptorPos, acceptorState, posAdder);
        }
        if ((block = level.getBlockEntity(acceptorPos)) instanceof IRecipeBookAcceptorBlockEntity) {
            IRecipeBookAcceptorBlockEntity rbaBlockEntity = (IRecipeBookAcceptorBlockEntity)block;
            rbaBlockEntity.addProxyRecipeBookAcceptorPositions(posAdder);
        }
    }
}

