/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.compression;

import com.petrolpark.core.recipe.compression.IItemCompressionSequence;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.math.Fraction;

public class CompressionItemHandler
implements IItemHandler,
INBTSerializable<CompoundTag> {
    protected int capacity;
    protected int count = 0;
    protected IItemCompressionSequence sequence;

    public CompressionItemHandler(IItemCompressionSequence sequence, int capacity) {
        this.sequence = sequence;
        this.capacity = capacity;
    }

    public int getSlots() {
        return this.sequence.size();
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.sequence.getAllItems().get(slot).copyWithCount(this.sequence.getEquivalentBaseItems(slot).multiplyBy(this.getBaseItemCount()).getProperWhole());
    }

    public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
        return this.insertItem(this.sequence.getEquivalentBaseItems(stack), stack, simulate);
    }

    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        this.validateSlotIndex(slot);
        if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.sequence.getAllItems().get(slot))) {
            return stack;
        }
        return this.insertItem(this.sequence.getEquivalentBaseItems(slot), stack, simulate);
    }

    protected ItemStack insertItem(Fraction equivalentBaseItems, @Nonnull ItemStack stack, boolean simulate) {
        if (equivalentBaseItems == null) {
            return stack;
        }
        Fraction baseItemAmountFraction = equivalentBaseItems.multiplyBy(Fraction.getFraction((int)stack.getCount(), (int)1));
        if (baseItemAmountFraction.subtract(this.getFreeSpace()).doubleValue() > 0.0) {
            baseItemAmountFraction = this.getFreeSpace();
        }
        int baseItemAmount = baseItemAmountFraction.getProperWhole();
        int amount = Fraction.getFraction((int)baseItemAmount, (int)1).divideBy(equivalentBaseItems).getProperWhole();
        baseItemAmount = equivalentBaseItems.multiplyBy(Fraction.getFraction((int)amount, (int)1)).intValue();
        if (!simulate) {
            this.count += baseItemAmount;
        }
        return stack.copyWithCount(stack.getCount() - amount);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlotIndex(slot);
        Fraction fraction = this.sequence.getEquivalentBaseItems(slot);
        Fraction baseItemAmountFraction = fraction.multiplyBy(Fraction.getFraction((int)amount, (int)1));
        if (baseItemAmountFraction.subtract(this.getBaseItemCount()).doubleValue() > 0.0) {
            baseItemAmountFraction = this.getBaseItemCount();
        }
        int baseItemAmount = baseItemAmountFraction.getProperWhole();
        amount = Fraction.getFraction((int)baseItemAmount, (int)1).divideBy(fraction).getProperWhole();
        baseItemAmount = fraction.multiplyBy(Fraction.getFraction((int)amount, (int)1)).intValue();
        if (!simulate) {
            this.count -= baseItemAmount;
        }
        return this.sequence.getAllItems().get(slot).copyWithCount(amount);
    }

    public int getSlotLimit(int slot) {
        this.validateSlotIndex(slot);
        return this.sequence.getEquivalentBaseItems(slot).multiplyBy(this.getCapacity()).getProperWhole();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.sequence.getAllItems().get(slot));
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.sequence.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.sequence.size() + ")");
        }
    }

    protected Fraction getCapacity() {
        return Fraction.getFraction((int)this.capacity, (int)1);
    }

    protected Fraction getBaseItemCount() {
        return Fraction.getFraction((int)this.count, (int)1);
    }

    protected Fraction getFreeSpace() {
        return this.getCapacity().subtract(this.getBaseItemCount());
    }

    public CompoundTag serializeNBT(@Nonnull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("Count", this.count);
        return tag;
    }

    public void deserializeNBT(@Nonnull HolderLookup.Provider provider, @Nonnull CompoundTag nbt) {
        this.count = nbt.getInt("Count");
    }
}

