/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.compression;

import com.petrolpark.core.recipe.compression.IItemCompression;
import com.petrolpark.core.recipe.compression.IItemCompressionSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.ItemStackMap;
import org.apache.commons.lang3.math.Fraction;

public class FinishableMapItemCompressionSequence
implements IItemCompressionSequence {
    protected boolean finished = false;
    protected final ItemStack baseItem;
    protected final Map<ItemStack, Fraction> fractionsByStack = ItemStackMap.createTypeAndTagMap();
    protected final List<Fraction> fractionsByIndex = new ArrayList<Fraction>();
    protected final List<ItemStack> allItems = new ArrayList<ItemStack>();
    protected final List<IItemCompression> compressions = new ArrayList<IItemCompression>();
    protected Optional<IItemCompressionSequence.CompressedBlock> baseBlock = Optional.empty();

    public FinishableMapItemCompressionSequence(ItemStack baseItem) {
        this.baseItem = baseItem;
        this.fractionsByIndex.add(Fraction.ONE);
        this.allItems.add(baseItem);
        this.checkToAddBaseBlock(baseItem);
    }

    public boolean add(IItemCompression compression) {
        if (this.finished) {
            throw new IllegalStateException("Cannot add Items to sequence after it is finished building.");
        }
        ItemStack newItem = compression.result().copyWithCount(1);
        if (this.fractionsByStack.containsKey(newItem)) {
            return false;
        }
        ItemStack lastItem = this.compressions.size() == 0 ? this.baseItem.copyWithCount(1) : this.compressions.get(this.compressions.size() - 1).result().copyWithCount(1);
        Fraction fraction = this.fractionsByIndex.get(this.fractionsByIndex.size() - 1).multiplyBy(Fraction.getFraction((int)compression.count(), (int)compression.result().getCount()));
        this.fractionsByStack.put(lastItem, fraction);
        this.fractionsByIndex.add(fraction);
        this.allItems.add(newItem);
        this.compressions.add(compression);
        this.checkToAddBaseBlock(newItem);
        return true;
    }

    @Override
    public ItemStack getBaseItem() {
        return this.baseItem;
    }

    @Override
    public List<ItemStack> getAllItems() {
        if (!this.finished) {
            throw new IllegalStateException("Cannot access Item Stacks of sequence before building it has been finished.");
        }
        return this.allItems;
    }

    @Override
    public List<IItemCompression> getAllCompressions() {
        if (!this.finished) {
            throw new IllegalStateException("Cannot access Compressions of sequence before building it has been finished.");
        }
        return this.compressions;
    }

    @Override
    public Fraction getEquivalentBaseItems(ItemStack stack) {
        Fraction fraction = this.fractionsByStack.get(stack);
        if (fraction == null) {
            return null;
        }
        return fraction.multiplyBy(Fraction.getFraction((int)stack.getCount(), (int)1));
    }

    @Override
    public double getEquivalentBaseItems(ItemStack stack, double count) {
        Fraction fraction = this.fractionsByStack.get(stack);
        if (fraction == null) {
            return 0.0;
        }
        return fraction.doubleValue() * count;
    }

    @Override
    public Fraction getEquivalentBaseItems(int item) {
        if (item < 0 || item >= this.fractionsByIndex.size()) {
            return null;
        }
        return this.fractionsByIndex.get(item);
    }

    @Override
    public Optional<IItemCompressionSequence.CompressedBlock> getBaseBlock() {
        if (!this.finished) {
            throw new IllegalStateException("Cannot access base Block of sequence before building it has been finished.");
        }
        return this.baseBlock;
    }

    protected void checkToAddBaseBlock(ItemStack stack) {
        Item item;
        if (this.baseBlock.isEmpty() && (item = stack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.baseBlock = Optional.of(new IItemCompressionSequence.CompressedBlock(blockItem.getBlock(), stack));
        }
    }

    public FinishableMapItemCompressionSequence finish() {
        this.finished = true;
        return this;
    }
}

