/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient.advanced;

import com.mojang.serialization.Codec;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredientType;
import com.petrolpark.core.recipe.ingredient.advanced.IForcingItemAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.INamedAdvancedIngredientType;
import com.petrolpark.core.recipe.ingredient.advanced.PassAdvancedIngredient;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;

public interface ItemAdvancedIngredient
extends IAdvancedIngredient<ItemStack>,
IForcingItemAdvancedIngredient {
    public static final Codec<IAdvancedIngredient<? super ItemStack>> TYPED_CODEC = PetrolparkRegistries.ADVANCED_ITEM_INGREDIENT_TYPES.byNameCodec().dispatch(IAdvancedIngredient::getType, IAdvancedIngredientType::codec);
    public static final Codec<IAdvancedIngredient<? super ItemStack>> CODEC = Codec.lazyInitialized(() -> Codec.withAlternative(TYPED_CODEC, (Codec)Codec.unit((Object)PassAdvancedIngredient.INSTANCE)));
    public static final StreamCodec<RegistryFriendlyByteBuf, IAdvancedIngredient<? super ItemStack>> STREAM_CODEC = ByteBufCodecs.registry(PetrolparkRegistries.Keys.ADVANCED_ITEM_INGREDIENT_TYPE).dispatch(IAdvancedIngredient::getType, IAdvancedIngredientType::streamCodec);

    @Override
    public boolean test(ItemStack var1);

    default public Component translate(String postfix, Object ... translationArgs) {
        return Component.translatable((String)(this.getType().translationKey() + "." + postfix), (Object[])translationArgs);
    }

    default public Component translateSimple(Object ... translationArgs) {
        return Component.translatable((String)this.getType().translationKey());
    }

    default public Component translateInverse(Object ... translationArgs) {
        return this.translate("inverse", translationArgs);
    }

    @Override
    @Nonnull
    default public Optional<ItemStack> forceLootItemFunction(LootItemFunction function, LootContext context, ItemStack stack) {
        return Optional.empty();
    }

    @Override
    @Nonnull
    default public Optional<ItemStack> forbidLootItemFunction(LootItemFunction function, LootContext context, ItemStack stack) {
        return Optional.empty();
    }

    @Override
    @Nullable
    default public Optional<MerchantOffer> forceTradeListing(VillagerTrades.ItemListing tradeListing, Entity trader, RandomSource random) {
        return null;
    }

    @Override
    @Nullable
    default public Optional<MerchantOffer> forbidTradeListing(VillagerTrades.ItemListing tradeListing, Entity trader, RandomSource random) {
        return null;
    }

    @Override
    public INamedAdvancedIngredientType<ItemStack> getType();
}

