/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient.advanced;

import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkAdvancedIngredientTypes;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.core.recipe.ingredient.advanced.INamedAdvancedIngredientType;
import com.petrolpark.core.recipe.ingredient.advanced.ItemAdvancedIngredient;
import com.petrolpark.util.CodecHelper;
import com.petrolpark.util.Lang;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record TagItemAdvancedIngredient(TagKey<Item> tag) implements ItemAdvancedIngredient
{
    public static final MapCodec<TagItemAdvancedIngredient> CODEC = CodecHelper.singleFieldMap(TagKey.codec((ResourceKey)Registries.ITEM), "tag", TagItemAdvancedIngredient::tag, TagItemAdvancedIngredient::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, TagItemAdvancedIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC.map(rl -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rl), TagKey::location), TagItemAdvancedIngredient::tag, TagItemAdvancedIngredient::new);

    @Override
    public boolean test(ItemStack stack) {
        return stack.is(this.tag());
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder description) {
        description.add(this.translateSimple(Lang.tag(this.tag())));
    }

    @Override
    public void addToCounterDescription(Lang.IndentedTooltipBuilder description) {
        description.add(this.translateInverse(Lang.tag(this.tag())));
    }

    @Override
    public INamedAdvancedIngredientType<ItemStack> getType() {
        return (INamedAdvancedIngredientType)PetrolparkAdvancedIngredientTypes.ITEM_TAG.get();
    }

    public record Type(String translationKey) implements INamedAdvancedIngredientType<ItemStack>
    {
        @Override
        public MapCodec<TagItemAdvancedIngredient> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, TagItemAdvancedIngredient> streamCodec() {
            return STREAM_CODEC;
        }

        @Override
        public Stream<TagItemAdvancedIngredient> streamApplicableIngredients(Level level, ItemStack stack) {
            return PetrolparkRegistries.getHolder((HolderLookup.Provider)level.registryAccess(), Registries.ITEM, stack.getItem()).stream().flatMap(Holder::tags).map(TagItemAdvancedIngredient::new);
        }
    }
}

