/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.recycling;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.core.recipe.recycling.RecyclingOutput;
import com.petrolpark.core.recipe.recycling.RecyclingOutputs;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;

public interface IRecyclingRecipe
extends Recipe<SingleRecipeInput> {
    public Ingredient ingredient();

    public RecyclingOutputs outputs();

    public static <R extends IRecyclingRecipe> MapCodec<R> codec(Factory<R> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(IRecyclingRecipe::ingredient), (App)RecyclingOutput.CODEC.listOf().xmap(RecyclingOutputs::new, Function.identity()).fieldOf("outputs").forGetter(IRecyclingRecipe::outputs)).apply((Applicative)instance, factory::create));
    }

    public static <R extends IRecyclingRecipe> StreamCodec<RegistryFriendlyByteBuf, R> streamCodec(Factory<R> factory) {
        return StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, IRecyclingRecipe::ingredient, RecyclingOutputs.STREAM_CODEC, IRecyclingRecipe::outputs, factory::create);
    }

    public static <R extends IRecyclingRecipe> NonNullSupplier<Serializer<R>> serializer(Factory<R> factory) {
        return () -> new Serializer(IRecyclingRecipe.codec(factory), IRecyclingRecipe.streamCodec(factory));
    }

    public static IRecyclingRecipe cast(Recipe<?> recipe) {
        if (recipe instanceof IRecyclingRecipe) {
            IRecyclingRecipe recyclingRecipe = (IRecyclingRecipe)recipe;
            return recyclingRecipe;
        }
        return null;
    }

    default public ItemStack assemble(@Nonnull SingleRecipeInput input, @Nonnull HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    default public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    default public ItemStack getResultItem(@Nonnull HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    default public NonNullList<Ingredient> getIngredients() {
        return NonNullList.copyOf(Collections.singleton(this.ingredient()));
    }

    @FunctionalInterface
    public static interface Factory<R extends IRecyclingRecipe> {
        public R create(Ingredient var1, RecyclingOutputs var2);
    }

    public record Serializer<R extends IRecyclingRecipe>(MapCodec<R> codec, StreamCodec<RegistryFriendlyByteBuf, R> streamCodec) implements RecipeSerializer<R>
    {
    }
}

