/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.scratch.argument;

import com.mojang.datafixers.kinds.Applicative;
import com.petrolpark.PetrolparkScratchClasses;
import com.petrolpark.core.codec.ContextualCodec;
import com.petrolpark.core.codec.ContextualMapCodec;
import com.petrolpark.core.codec.ContextualStreamCodec;
import com.petrolpark.core.codec.RecordContextualCodecBuilder;
import com.petrolpark.core.scratch.argument.ExpressionArgument;
import com.petrolpark.core.scratch.argument.IScratchArgument;
import com.petrolpark.core.scratch.argument.IScratchParameter;
import com.petrolpark.core.scratch.classes.IParseableScratchClass;
import com.petrolpark.core.scratch.environment.IScratchEnvironment;
import com.petrolpark.core.scratch.procedure.IScratchContext;
import com.petrolpark.core.scratch.procedure.IScratchContextHolder;
import com.petrolpark.core.scratch.procedure.IScratchContextProvider;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;

public final class ExpressionOrLiteralArgument<ENVIRONMENT extends IScratchEnvironment, TYPE>
extends Record
implements IScratchArgument<ENVIRONMENT, TYPE>,
IScratchContextHolder {
    private final TYPE value;
    private final Optional<ExpressionArgument<ENVIRONMENT, TYPE, ?>> expression;
    private final ExpressionOrLiteralParameter<ENVIRONMENT, TYPE> parameter;

    public ExpressionOrLiteralArgument(TYPE value, Optional<ExpressionArgument<ENVIRONMENT, TYPE, ?>> expression, ExpressionOrLiteralParameter<ENVIRONMENT, TYPE> parameter) {
        this.value = value;
        this.expression = expression;
        this.parameter = parameter;
    }

    public static <ENVIRONMENT extends IScratchEnvironment> ExpressionOrLiteralParameter<ENVIRONMENT, Long> integerParameter(String key) {
        return new ExpressionOrLiteralParameter(key, (IParseableScratchClass)PetrolparkScratchClasses.INTEGER.get());
    }

    public static <ENVIRONMENT extends IScratchEnvironment> ExpressionOrLiteralParameter<ENVIRONMENT, Double> realParameter(String key) {
        return new ExpressionOrLiteralParameter(key, (IParseableScratchClass)PetrolparkScratchClasses.REAL.get());
    }

    public static <ENVIRONMENT extends IScratchEnvironment> ExpressionOrLiteralParameter<ENVIRONMENT, String> stringParameter(String key) {
        return new ExpressionOrLiteralParameter(key, (IParseableScratchClass)PetrolparkScratchClasses.STRING.get());
    }

    @Override
    public TYPE get(ENVIRONMENT environment) {
        return (TYPE)this.expression().map(expression -> expression.get(environment)).orElse(this.value());
    }

    @Override
    public <CONTEXT extends IScratchContext<CONTEXT>> void populateContext(IScratchContextProvider<CONTEXT> contextProvider, CONTEXT context) {
        this.expression().ifPresent(expression -> expression.populateContext(contextProvider, context));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ExpressionOrLiteralArgument.class, "value;expression;parameter", "value", "expression", "parameter"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ExpressionOrLiteralArgument.class, "value;expression;parameter", "value", "expression", "parameter"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ExpressionOrLiteralArgument.class, "value;expression;parameter", "value", "expression", "parameter"}, this, o);
    }

    public TYPE value() {
        return this.value;
    }

    public Optional<ExpressionArgument<ENVIRONMENT, TYPE, ?>> expression() {
        return this.expression;
    }

    public ExpressionOrLiteralParameter<ENVIRONMENT, TYPE> parameter() {
        return this.parameter;
    }

    public static final class ExpressionOrLiteralParameter<ENVIRONMENT extends IScratchEnvironment, TYPE>
    implements IScratchParameter<ENVIRONMENT, TYPE, ExpressionOrLiteralArgument<ENVIRONMENT, TYPE>> {
        private final ExpressionArgument.ExpressionParameter<ENVIRONMENT, TYPE> expressionParameter;
        private final ContextualCodec<IScratchContextProvider<?>, ExpressionOrLiteralArgument<ENVIRONMENT, TYPE>> codec;
        private final ContextualStreamCodec<? super RegistryFriendlyByteBuf, IScratchContextProvider<?>, ExpressionOrLiteralArgument<ENVIRONMENT, TYPE>> streamCodec;

        public ExpressionOrLiteralParameter(String key, IParseableScratchClass<TYPE, ?> scratchClass) {
            this.expressionParameter = new ExpressionArgument.ExpressionParameter(key, scratchClass);
            this.codec = RecordContextualCodecBuilder.create(instance -> instance.group(((ContextualMapCodec)ContextualCodec.of(scratchClass.codec()).fieldOf("literal")).forGetter(ExpressionOrLiteralArgument::value), this.expressionParameter.argumentCodec().optionalFieldOf("expression").forGetter(ExpressionOrLiteralArgument::expression)).apply((Applicative)instance, (value, expression) -> new ExpressionOrLiteralArgument(value, expression, this)));
            this.streamCodec = ContextualStreamCodec.composite(ContextualStreamCodec.of(scratchClass.streamCodec()), ExpressionOrLiteralArgument::value, ContextualStreamCodec.optional(this.expressionParameter.argumentStreamCodec()), ExpressionOrLiteralArgument::expression, (value, expression) -> new ExpressionOrLiteralArgument(value, expression, this));
        }

        @Override
        public String key() {
            return this.expressionParameter.key();
        }

        @Override
        public ContextualCodec<IScratchContextProvider<?>, ExpressionOrLiteralArgument<ENVIRONMENT, TYPE>> argumentCodec() {
            return this.codec;
        }

        @Override
        public ContextualStreamCodec<? super RegistryFriendlyByteBuf, IScratchContextProvider<?>, ExpressionOrLiteralArgument<ENVIRONMENT, TYPE>> argumentStreamCodec() {
            return this.streamCodec;
        }
    }
}

