/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.shop.customer;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.core.shop.Shop;
import com.petrolpark.core.shop.customer.ICustomer;
import com.petrolpark.core.shop.offer.ShopOffer;
import com.petrolpark.util.NBTHelper;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.slf4j.Logger;

public abstract class AbstractCustomer
implements ICustomer,
INBTSerializable<CompoundTag> {
    public int orderTime = -1;
    protected int elapsedOrderTime = 0;
    protected ShopOffer openOffer = null;
    protected Shop shop = null;

    @Override
    public int getOrderTime() {
        return this.orderTime;
    }

    @Override
    public int getElapsedOrderTime() {
        return this.elapsedOrderTime;
    }

    @Override
    public ShopOffer getOpenOffer() {
        return this.openOffer;
    }

    @Override
    public Shop getShop() {
        return this.shop;
    }

    @Override
    public void clearOpenOffer() {
        this.orderTime = -1;
        this.elapsedOrderTime = 0;
        this.openOffer = null;
        this.shop = null;
    }

    public CompoundTag serializeNBT(@Nonnull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (this.getOrderTime() != -1) {
            tag.putInt("OrderTime", this.orderTime);
            if (this.elapsedOrderTime > 0) {
                tag.putInt("Elapsed", this.elapsedOrderTime);
            }
        }
        if (this.openOffer != null) {
            ShopOffer.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.openOffer).resultOrPartial(arg_0 -> ((Logger)Petrolpark.LOGGER).warn(arg_0)).ifPresent(t -> tag.put("Offer", t));
        }
        if (this.getShop() != null) {
            PetrolparkRegistries.getHolder(provider, PetrolparkRegistries.Keys.SHOP, this.getShop());
        }
        return tag;
    }

    public void deserializeNBT(@Nonnull HolderLookup.Provider provider, @Nonnull CompoundTag nbt) {
        this.orderTime = -1;
        if (nbt.contains("OrderTime", 3)) {
            this.orderTime = nbt.getInt("OrderTime");
            if (nbt.contains("Elapsed", 3)) {
                this.elapsedOrderTime = nbt.getInt("Elapsed");
            }
        }
        if (nbt.contains("Offer", 10)) {
            ShopOffer.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("Offer")).resultOrPartial(arg_0 -> ((Logger)Petrolpark.LOGGER).warn(arg_0)).map(Pair::getFirst).ifPresent(s -> {
                this.openOffer = s;
            });
        }
        if (nbt.contains("Shop", 8)) {
            this.shop = NBTHelper.readDataRegistryObject(nbt, "Shop", PetrolparkRegistries.Keys.SHOP);
        }
    }

    public void tick() {
        if (this.elapsedOrderTime < this.orderTime && this.orderTime != -1) {
            ++this.elapsedOrderTime;
        }
    }
}

