/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.shop.offer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.core.data.reward.generator.IRewardGenerator;
import com.petrolpark.core.recipe.ingredient.randomizer.IngredientRandomizer;
import com.petrolpark.core.shop.Shop;
import com.petrolpark.core.shop.offer.ShopOffer;
import com.petrolpark.core.shop.offer.order.ShopOrder;
import com.petrolpark.core.shop.offer.order.ShopOrderModifierEntry;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootContextUser;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class ShopOfferGenerator
implements LootContextUser {
    public static final Codec<ShopOfferGenerator> DIRECT_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)NumberProviders.CODEC.optionalFieldOf("time", (Object)ConstantValue.exactly((float)-1.0f)).forGetter(ShopOfferGenerator::getTimeGenerator), (App)IRewardGenerator.CODEC.fieldOf("reward").forGetter(ShopOfferGenerator::getRewardGenerator), (App)IngredientRandomizer.CODEC.fieldOf("order").forGetter(ShopOfferGenerator::getOrderRandomizer), (App)Codec.list(ShopOrderModifierEntry.CODEC).optionalFieldOf("orderModifiers", Collections.emptyList()).forGetter(ShopOfferGenerator::getOrderModifiers)).apply((Applicative)instance, ShopOfferGenerator::new)));
    public final NumberProvider timeGenerator;
    public final IRewardGenerator rewardGenerator;
    public final IngredientRandomizer orderRandomizer;
    public final List<ShopOrderModifierEntry> orderModifiers;

    public ShopOfferGenerator(NumberProvider timeGenerator, IRewardGenerator rewardGenerator, IngredientRandomizer orderRandomizer, List<ShopOrderModifierEntry> orderModifiers) {
        this.timeGenerator = timeGenerator;
        this.rewardGenerator = rewardGenerator;
        this.orderRandomizer = orderRandomizer;
        this.orderModifiers = orderModifiers;
    }

    public ShopOffer generate(LootContext context, Shop shop) {
        return new ShopOffer(this.rewardGenerator.generate(context), new ShopOrder(this.orderRandomizer.generate(context), Stream.concat(this.orderModifiers.stream(), shop.getGlobalOrderModifierEntries().stream()).filter(ome -> ome.chance().getFloat(context) < context.getRandom().nextFloat()).map(ShopOrderModifierEntry::orderModifier).toList()));
    }

    public NumberProvider getTimeGenerator() {
        return this.timeGenerator;
    }

    public IRewardGenerator getRewardGenerator() {
        return this.rewardGenerator;
    }

    public IngredientRandomizer getOrderRandomizer() {
        return this.orderRandomizer;
    }

    public List<ShopOrderModifierEntry> getOrderModifiers() {
        return this.orderModifiers;
    }
}

