/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.team;

import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkDataComponents;
import com.petrolpark.core.team.GatherTeamProvidersEvent;
import com.petrolpark.core.team.ITeam;
import com.petrolpark.core.team.NoTeam;
import com.petrolpark.core.team.SelectTeamScreen;
import com.petrolpark.core.team.packet.BindTeamItemPacket;
import com.petrolpark.util.ScreenHelper;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public interface ITeamBoundItem {
    public static final String TEAM_TAG_KEY = "Team";

    public boolean isTeamRebindable(Level var1, Player var2, ItemStack var3);

    @OnlyIn(value=Dist.CLIENT)
    public Component getTeamSelectionScreenTitle(Level var1, Player var2, ItemStack var3);

    default public InteractionResult trySelectTeam(ItemStack stack, Player player, Level level) {
        if (!ITeamBoundItem.getTeam(stack, level).isNone() && !this.isTeamRebindable(level, player, stack)) {
            return InteractionResult.PASS;
        }
        GatherTeamProvidersEvent event = new GatherTeamProvidersEvent(player);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.getTeamProvidersUnmodifiable().size() == 1) {
            this.bind(event.getTeamProvidersUnmodifiable().get(0), stack, player);
        } else if (level.isClientSide()) {
            Petrolpark.unsafeRunClient(() -> () -> ITeamBoundItem.openScreen(this.getTeamSelectionScreenTitle(level, player, stack), event.getTeamsUnmodifiable(level)));
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openScreen(Component title, List<ITeam> teams) {
        ScreenHelper.openScreen((Screen)new SelectTeamScreen(title, teams, BindTeamItemPacket::new));
    }

    public static ITeam getTeam(ItemStack stack, Level level) {
        return ((ITeam.Provider)stack.getOrDefault(PetrolparkDataComponents.TEAM_PROVIDER, (Object)NoTeam.INSTANCE)).provideTeam(level);
    }

    default public void bind(ITeam.Provider teamProvider, ItemStack stack, Player player) {
        if (stack.getItem() != this) {
            return;
        }
        if (!this.isTeamRebindable(player.level(), player, stack) && stack.has(PetrolparkDataComponents.TEAM_PROVIDER)) {
            return;
        }
        stack.set(PetrolparkDataComponents.TEAM_PROVIDER, (Object)teamProvider);
    }
}

