/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.team.scoreboard;

import com.mojang.serialization.DynamicOps;
import com.petrolpark.core.team.ITeam;
import com.petrolpark.core.team.scoreboard.ScoreboardTeam;
import com.petrolpark.core.team.scoreboard.ScoreboardTeamComponentChangedPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

public class ScoreboardTeamManager {
    protected final Map<PlayerTeam, ScoreboardTeam> teams = new HashMap<PlayerTeam, ScoreboardTeam>();
    protected ScoreboardTeamSavedData savedData;

    public Optional<ITeam> get(Level level, String teamName) {
        PlayerTeam team = level.getScoreboard().getPlayerTeam(teamName);
        if (team == null) {
            return Optional.empty();
        }
        return Optional.of((ITeam)this.teams.computeIfAbsent(team, t -> new ScoreboardTeam(level, (PlayerTeam)t)));
    }

    public <T> void dataComponentChanged(Level level, ScoreboardTeam team, @Nonnull DataComponentPatch patch) {
        CatnipServices.PLATFORM.executeOnServerOnly(() -> () -> CatnipServices.NETWORK.sendToAllClients((CustomPacketPayload)new ScoreboardTeamComponentChangedPacket(team.team.getName(), patch)));
        this.markDirty();
    }

    public <T> void applyPatch(Level level, String teamName, DataComponentPatch patch) {
        this.get(level, teamName).ifPresent(team -> team.applyComponents(patch));
        this.markDirty();
    }

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.loadSavedData(serverPlayer.getServer());
            for (ScoreboardTeam team : this.teams.values()) {
                CatnipServices.NETWORK.sendToClient(serverPlayer, (CustomPacketPayload)new ScoreboardTeamComponentChangedPacket(team.team.getName(), team.getDataComponentPatch()));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
    }

    @SubscribeEvent
    public void onLoadLevel(LevelEvent.Load event) {
        LevelAccessor level = event.getLevel();
        MinecraftServer server = level.getServer();
        if (server == null || server.overworld() != level) {
            return;
        }
        this.teams.clear();
        this.savedData = null;
        this.loadSavedData(server);
    }

    private void loadSavedData(MinecraftServer server) {
        if (this.savedData != null) {
            return;
        }
        this.savedData = (ScoreboardTeamSavedData)server.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new ScoreboardTeamSavedData(), (tag, registries) -> this.load((Level)server.overworld(), (CompoundTag)tag)), "petrolpark_teams");
    }

    public void markDirty() {
        if (this.savedData != null) {
            this.savedData.setDirty();
        }
    }

    protected ScoreboardTeamSavedData load(Level overworld, CompoundTag tag) {
        ScoreboardTeamSavedData savedData = new ScoreboardTeamSavedData();
        for (String key : tag.getAllKeys()) {
            if (!tag.contains(key, 10)) continue;
            this.get(overworld, key).ifPresent(team -> team.applyComponents((DataComponentPatch)DataComponentPatch.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(key)).getOrThrow()));
        }
        return savedData;
    }

    public class ScoreboardTeamSavedData
    extends SavedData {
        public CompoundTag save(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider registries) {
            for (ScoreboardTeam team : ScoreboardTeamManager.this.teams.values()) {
                tag.put(team.team.getName(), team.writeDataComponentsTag());
            }
            return tag;
        }
    }
}

