/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.wish;

import com.mojang.serialization.Codec;
import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.ItemAdvancedIngredient;
import com.petrolpark.core.wish.AbstractWishList;
import com.petrolpark.core.wish.WishGrantedPacket;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.createmod.catnip.codecs.CatnipCodecUtils;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import org.jetbrains.annotations.Nullable;

public class PlayerWishList
extends AbstractWishList {
    public static final Codec<Map<IAdvancedIngredient<? super ItemStack>, Integer>> CODEC = Codec.unboundedMap(ItemAdvancedIngredient.CODEC, (Codec)Codec.INT);
    public static final IAttachmentSerializer<Tag, PlayerWishList> SERIALIZER = new Serializer();
    protected final Player player;
    protected final Object2IntMap<IAdvancedIngredient<? super ItemStack>> wishes = new Object2IntOpenHashMap();

    public PlayerWishList(IAttachmentHolder attachmentHolder) {
        this(attachmentHolder, Collections.emptyMap());
    }

    public PlayerWishList(PlayerWishList oldList, IAttachmentHolder attachmentHolder, HolderLookup.Provider registries) {
        this(attachmentHolder, (Map<IAdvancedIngredient<? super ItemStack>, Integer>)oldList.wishes);
    }

    public PlayerWishList(IAttachmentHolder attachmentHolder, Map<IAdvancedIngredient<? super ItemStack>, Integer> wishes) {
        if (!(attachmentHolder instanceof Player)) {
            throw new IllegalArgumentException("Only Players can have WishLists");
        }
        Player player = (Player)attachmentHolder;
        this.player = player;
        this.wishes.putAll(wishes);
        this.wishes.defaultReturnValue(0);
    }

    @Override
    public Collection<IAdvancedIngredient<? super ItemStack>> getWishes() {
        return this.wishes.keySet();
    }

    @Override
    public int getWishInstanceCount(IAdvancedIngredient<? super ItemStack> wish, int maxFulfillments) {
        return Math.min(maxFulfillments, this.wishes.getInt(wish));
    }

    @Override
    public void fulfillWish(IAdvancedIngredient<? super ItemStack> wish, ItemStack stack) {
        Player player;
        if (this.wishes.containsKey(wish) && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CatnipServices.NETWORK.sendToClient(serverPlayer, (CustomPacketPayload)new WishGrantedPacket(wish, stack));
        }
        this.wishes.computeInt(wish, (w, c) -> c == 1 ? null : Integer.valueOf(c - 1));
    }

    public static class Serializer
    implements IAttachmentSerializer<Tag, PlayerWishList> {
        public PlayerWishList read(@Nonnull IAttachmentHolder holder, @Nonnull Tag tag, @Nonnull HolderLookup.Provider provider) {
            return CatnipCodecUtils.decode(CODEC, (Tag)tag).map(map -> new PlayerWishList(holder, (Map<IAdvancedIngredient<? super ItemStack>, Integer>)map)).orElse(new PlayerWishList(holder));
        }

        @Nullable
        public Tag write(@Nonnull PlayerWishList attachment, @Nonnull HolderLookup.Provider provider) {
            return CatnipCodecUtils.encode(CODEC, attachment.wishes).orElse(null);
        }
    }
}

