/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.event;

import com.mojang.brigadier.CommandDispatcher;
import com.petrolpark.Petrolpark;
import com.petrolpark.common.mobeffect.shader.IShaderEffect;
import com.petrolpark.common.mobeffect.shader.packet.RemoveAllEffectShadersPacket;
import com.petrolpark.config.PetrolparkConfigs;
import com.petrolpark.core.contamination.Contaminant;
import com.petrolpark.core.contamination.ContaminateHeldItemCommand;
import com.petrolpark.core.contamination.ItemContamination;
import com.petrolpark.core.item.decay.ItemDecay;
import com.petrolpark.core.recipe.bogglepattern.BogglePatternCommand;
import com.petrolpark.util.mixininterfaces.IGameRendererMixin;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.brewing.PotionBrewEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class CommonEvents {
    public static final ResourceLocation PLAYER_JOINS_FUNCTION_TAG = Petrolpark.asResource("player_joins");

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        ContaminateHeldItemCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
        BogglePatternCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new Contaminant.ReloadListener(event.getRegistryAccess()));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        MinecraftServer server;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (server = (player = (ServerPlayer)player2).getServer()) != null) {
            server.getFunctions().getTag(PLAYER_JOINS_FUNCTION_TAG).forEach(function -> server.getFunctions().execute(function, player.createCommandSourceStack().withPermission(server.getFunctionCompilationLevel())));
        }
    }

    @SubscribeEvent
    public static void onPotionBrewed(PotionBrewEvent.Post event) {
        for (int slot = 0; slot < 3; ++slot) {
            ItemStack potion = event.getItem(slot);
            ItemDecay.startDecay(potion);
            if (!((Boolean)PetrolparkConfigs.server().brewingPropagatesContaminants.get()).booleanValue()) continue;
            ItemContamination.perpetuateSingle(Stream.of(event.getItem(3), potion).dropWhile(s -> {
                if ((Boolean)PetrolparkConfigs.server().brewingWaterBottleContaminantsIgnored.get() == false) return false;
                if (((PotionContents)s.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion().map(arg_0 -> ((Holder)Potions.WATER).equals(arg_0)).orElse(false) == false) return false;
                return true;
            }), potion);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPlayerLogOut(ClientPlayerNetworkEvent.LoggingOut event) {
        IGameRendererMixin gameRenderer = (IGameRendererMixin)Minecraft.getInstance().gameRenderer;
        gameRenderer.petrolpark$cleanShaderEffects();
    }

    @SubscribeEvent
    public static void onMobEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance == null) {
            return;
        }
        Holder effectHolder = effectInstance.getEffect();
        Object object = effectHolder.value();
        if (object instanceof IShaderEffect) {
            IShaderEffect shaderEffect = (IShaderEffect)object;
            object = event.getEntity();
            if (object instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)object;
                shaderEffect.cleanupShader(serverPlayer, (Holder<MobEffect>)effectHolder);
            }
        }
    }

    @SubscribeEvent
    public static void onMobEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance == null) {
            return;
        }
        Holder effectHolder = effectInstance.getEffect();
        Object object = effectHolder.value();
        if (object instanceof IShaderEffect) {
            IShaderEffect shaderEffect = (IShaderEffect)object;
            object = event.getEntity();
            if (object instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)object;
                shaderEffect.cleanupShader(serverPlayer, (Holder<MobEffect>)effectHolder);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RemoveAllEffectShadersPacket(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

