/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.petrolpark.core.contamination.IContamination;
import com.petrolpark.core.contamination.ItemContamination;
import com.petrolpark.core.item.IItemStackDuck;
import com.petrolpark.core.item.decay.ItemDecay;
import com.petrolpark.util.ItemHelper;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemStack.class})
public class ItemStackMixin
implements IItemStackDuck {
    @Unique
    private IContamination<?, ?> contamination;

    @ModifyReturnValue(method={"copy"}, at={@At(value="RETURN")})
    public ItemStack modifyCopy(ItemStack itemStack) {
        return ItemDecay.checkDecay(itemStack);
    }

    @WrapMethod(method={"isSameItemSameComponents"})
    private static boolean modifyIsSameItemSameComponents(ItemStack stack, ItemStack otherStack, Operation<Boolean> original) {
        return (Boolean)original.call(new Object[]{stack, otherStack}) != false || ItemHelper.equalIgnoringComponents(stack, otherStack, new DataComponentType[0]);
    }

    @Override
    public IContamination<?, ?> getContamination() {
        if (this.contamination == null) {
            this.contamination = ItemContamination.create(this.self());
        }
        return this.contamination;
    }

    @Override
    public void onContaminationSaved() {
        this.contamination = null;
    }

    private ItemStack self() {
        return (ItemStack)this;
    }
}

