/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin.client;

import com.petrolpark.PetrolparkMobEffects;
import com.petrolpark.core.inventory.extended.ExtendedInventory;
import com.petrolpark.core.inventory.extended.ExtendedInventoryClientHandler;
import java.util.Optional;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Shadow
    abstract Player getCameraPlayer();

    @Shadow
    public abstract void renderSlot(GuiGraphics var1, int var2, int var3, DeltaTracker var4, Player var5, ItemStack var6, int var7);

    @ModifyArg(method={"renderItemHotbar"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;renderSlot(Lnet/minecraft/client/gui/GuiGraphics;IILnet/minecraft/client/DeltaTracker;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;I)V"), index=1)
    private int modifyOffhandItemOffset(GuiGraphics graphics, int x, int y, DeltaTracker deltaTracker, Player player, ItemStack stack, int seed) {
        if (stack == player.getOffhandItem()) {
            Optional<ExtendedInventory> invOp = ExtendedInventory.get(player);
            if (invOp.isEmpty()) {
                return x;
            }
            ExtendedInventory inv = invOp.get();
            x = player.getMainArm().getOpposite() == HumanoidArm.LEFT ? (x -= 20 * ExtendedInventoryClientHandler.getLeftExtraHotbarSlots(inv.getExtraHotbarSlots())) : (x += 20 * ExtendedInventoryClientHandler.getRightExtraHotbarSlots(inv.getExtraHotbarSlots()));
        }
        return x;
    }

    @ModifyArg(method={"renderItemHotbar"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lnet/minecraft/resources/ResourceLocation;IIII)V"), index=1)
    private int modifyOffhandBackgroundOffsetX(ResourceLocation atlasLocation, int x, int y, int width, int height) {
        if (atlasLocation == Gui.HOTBAR_OFFHAND_LEFT_SPRITE || atlasLocation == Gui.HOTBAR_OFFHAND_RIGHT_SPRITE) {
            Optional<ExtendedInventory> invOp = ExtendedInventory.get(this.getCameraPlayer());
            if (invOp.isEmpty()) {
                return x;
            }
            ExtendedInventory inv = invOp.get();
            if (this.getCameraPlayer().getMainArm().getOpposite() == HumanoidArm.LEFT) {
                return x -= 20 * ExtendedInventoryClientHandler.getLeftExtraHotbarSlots(inv.getExtraHotbarSlots());
            }
            return x += 20 * ExtendedInventoryClientHandler.getRightExtraHotbarSlots(inv.getExtraHotbarSlots());
        }
        return x;
    }

    @ModifyArg(method={"renderHealthLevel"}, at=@At(value="INVOKE", target="renderHearts(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/player/Player;IIIIFIIIZ)V"), index=10)
    private boolean modifyRenderHighlight(boolean renderHighlight) {
        return renderHighlight && !this.getCameraPlayer().hasEffect(PetrolparkMobEffects.NUMBNESS.getDelegate());
    }
}

