/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import com.petrolpark.util.Pair;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;

public class BlockFace
extends Pair<BlockPos, Direction> {
    public static final StreamCodec<ByteBuf, BlockFace> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, BlockFace::getPos, (StreamCodec)Direction.STREAM_CODEC, BlockFace::getFace, BlockFace::of);

    public static BlockFace of(BlockPos pos, Direction face) {
        return new BlockFace(pos, face);
    }

    public BlockFace(BlockPos first, Direction second) {
        super(first, second);
    }

    public BlockPos getPos() {
        return (BlockPos)this.getFirst();
    }

    public Direction getFace() {
        return (Direction)this.getSecond();
    }

    public BlockPos getConnectedPos() {
        return this.getPos().relative(this.getFace());
    }

    public BlockFace getOpposite() {
        return new BlockFace(this.getConnectedPos(), this.getFace().getOpposite());
    }

    public Vec3 getCenter() {
        return Vec3.atCenterOf((Vec3i)this.getPos()).add(new Vec3(this.getFace().step()).scale(0.5));
    }
}

