/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import com.petrolpark.util.MathsHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ClampedCubicSpline {
    protected Vec3 startTangent;
    protected Vec3 endTangent;
    protected List<Vec3> controlPoints;
    public final double segmentLength;
    protected double totalLength = 0.0;
    protected ArrayList<Vec3> points;
    protected ArrayList<Vec3> tangents;
    protected AABB occupiedVolume;

    public ClampedCubicSpline(List<Vec3> controlPoints, Vec3 startDir, Vec3 endDir, double segmentLength) {
        this.controlPoints = controlPoints;
        this.startTangent = startDir;
        this.endTangent = endDir;
        this.segmentLength = segmentLength;
        this.recalculate();
    }

    protected ClampedCubicSpline(Vec3 start, Vec3 end, Vec3 startDir, Vec3 endDir, double segmentLength) {
        this.controlPoints = new ArrayList<Vec3>();
        this.controlPoints.add(start);
        this.controlPoints.add(end);
        this.startTangent = startDir;
        this.endTangent = endDir;
        this.segmentLength = segmentLength;
    }

    public Vec3 getStartTangent() {
        return this.startTangent;
    }

    public Vec3 getEndTangent() {
        return this.endTangent;
    }

    public List<Vec3> getControlPoints() {
        return this.controlPoints;
    }

    public List<Vec3> getPoints() {
        return this.points;
    }

    public List<Vec3> getTangents() {
        return this.tangents;
    }

    public double getLength() {
        return this.totalLength;
    }

    public AABB getOccupiedVolume() {
        return this.occupiedVolume;
    }

    public void addControlPoint(Vec3 controlPoint) {
        this.controlPoints.add(this.controlPoints.size() - 1, controlPoint);
        this.recalculate();
    }

    public void addInterpolatedControlPoint(int index) {
        this.controlPoints.add(index, this.controlPoints.get(index - 1).add(this.controlPoints.get(index)).scale(0.5));
        this.recalculate();
    }

    public void removeControlPoint(int index) {
        this.controlPoints.remove(index);
        this.recalculate();
    }

    public boolean moveControlPoint(int controlPointIndex, Vec3 newLocation) {
        if (newLocation.distanceToSqr(this.controlPoints.get(controlPointIndex)) < 0.015625) {
            return false;
        }
        this.controlPoints.set(controlPointIndex, newLocation);
        this.recalculate();
        return true;
    }

    public void recalculate() {
        int n = this.controlPoints.size() - 1;
        Vec3[] controlTangents = new Vec3[this.controlPoints.size()];
        controlTangents[0] = this.startTangent;
        controlTangents[n] = this.endTangent;
        for (int i = 1; i < n; ++i) {
            Vec3 diff = this.controlPoints.get(i + 1).subtract(this.controlPoints.get(i - 1));
            controlTangents[i] = diff.scale(0.5);
        }
        double[] lengths = new double[n];
        this.totalLength = 0.0;
        for (int i = 0; i < n; ++i) {
            lengths[i] = ClampedCubicSpline.approximateSegmentLength(this.controlPoints.get(i), this.controlPoints.get(i + 1), controlTangents[i], controlTangents[i + 1], 10);
            this.totalLength += lengths[i];
        }
        int pointCount = (int)(1.0 + this.totalLength / this.segmentLength);
        ArrayList<Integer> segmentPointCounts = new ArrayList<Integer>();
        double density = (double)pointCount / this.totalLength;
        for (double length : lengths) {
            segmentPointCounts.add((int)Math.max(1L, Math.round(length * density)));
        }
        this.points = new ArrayList();
        this.tangents = new ArrayList();
        this.occupiedVolume = new AABB(this.controlPoints.get(0), this.controlPoints.get(this.controlPoints.size() - 1));
        for (int i = 0; i < n; ++i) {
            Vec3 p0 = this.controlPoints.get(i);
            Vec3 p1 = this.controlPoints.get(i + 1);
            Vec3 m0 = controlTangents[i];
            Vec3 m1 = controlTangents[i + 1];
            int segmentPointCount = (Integer)segmentPointCounts.get(i);
            for (int j = 0; j < segmentPointCount; ++j) {
                double t = (double)j / (double)(segmentPointCount - 1);
                Vec3 point = ClampedCubicSpline.interpolateSegment(p0, p1, m0, m1, t);
                Vec3 tangent = ClampedCubicSpline.interpolateTangent(p0, p1, m0, m1, t).normalize();
                this.points.add(point);
                this.tangents.add(tangent);
                this.occupiedVolume = MathsHelper.expandToInclude(this.occupiedVolume, point);
                this.forEachSegment(i, point, tangent);
            }
        }
    }

    protected void forEachSegment(int index, Vec3 point, Vec3 tangent) {
    }

    private static double approximateSegmentLength(Vec3 p0, Vec3 p1, Vec3 m0, Vec3 m1, int samples) {
        double length = 0.0;
        Vec3 prevPoint = p0;
        for (int i = 1; i <= samples; ++i) {
            double t = (double)i / (double)samples;
            Vec3 currentPoint = ClampedCubicSpline.interpolateSegment(p0, p1, m0, m1, t);
            length += currentPoint.subtract(prevPoint).length();
            prevPoint = currentPoint;
        }
        return length;
    }

    private static Vec3 interpolateSegment(Vec3 p0, Vec3 p1, Vec3 m0, Vec3 m1, double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        double h00 = 2.0 * t3 - 3.0 * t2 + 1.0;
        double h10 = t3 - 2.0 * t2 + t;
        double h01 = -2.0 * t3 + 3.0 * t2;
        double h11 = t3 - t2;
        return p0.scale(h00).add(m0.scale(h10)).add(p1.scale(h01)).add(m1.scale(h11));
    }

    private static Vec3 interpolateTangent(Vec3 p0, Vec3 p1, Vec3 m0, Vec3 m1, double t) {
        double t2 = t * t;
        double h00 = 6.0 * t2 - 6.0 * t;
        double h10 = 3.0 * t2 - 4.0 * t + 1.0;
        double h01 = -6.0 * t2 + 6.0 * t;
        double h11 = 3.0 * t2 - 2.0 * t;
        return p0.scale(h00).add(m0.scale(h10)).add(p1.scale(h01)).add(m1.scale(h11));
    }
}

