/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.petrolpark.util.MathsHelper;
import com.petrolpark.util.NestedSequenceBiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class EnumSequenceBiMap<K extends Enum<K>, V>
extends NestedSequenceBiMap<K, V> {
    protected final EnumMap<K, NestedSequenceBiMap.Entry<K, V>> entryMap;
    protected final Supplier<Map<V, List<K>>> sequenceMap;

    public EnumSequenceBiMap(Class<K> enumClass, int size) {
        this(new EnumMap(enumClass));
    }

    public EnumSequenceBiMap(Map<K, NestedSequenceBiMap.Entry<K, V>> entryMap) {
        this(new EnumMap<K, NestedSequenceBiMap.Entry<K, V>>(entryMap));
    }

    protected EnumSequenceBiMap(EnumMap<K, NestedSequenceBiMap.Entry<K, V>> entryMap) {
        this.entryMap = entryMap;
        this.sequenceMap = Suppliers.memoize(() -> {
            HashMap sequenceMap = new HashMap();
            EnumSequenceBiMap.populateSequenceMap(sequenceMap, new NestedSequenceBiMap.Entry.SubMapEntry(this), Collections.emptyList());
            return sequenceMap;
        });
    }

    @Override
    public Map<V, List<K>> getKeySequenceMap() {
        return this.sequenceMap.get();
    }

    @Override
    protected Map<K, NestedSequenceBiMap.Entry<K, V>> getEntryMap() {
        return this.entryMap;
    }

    private static final <K extends Enum<K>, V> EnumSequenceBiMap<K, V> cast(NestedSequenceBiMap<K, V> map) {
        if (map instanceof EnumSequenceBiMap) {
            EnumSequenceBiMap enumMap = (EnumSequenceBiMap)map;
            return enumMap;
        }
        return null;
    }

    public static final <K extends Enum<K>, V> Codec<EnumSequenceBiMap<K, V>> codec(Codec<K> keyCodec, Codec<V> valueCodec) {
        return Codec.recursive((String)"EnumSequenceBiMap", wrappedMapCodec -> Codec.unboundedMap((Codec)keyCodec, (Codec)Codec.either((Codec)wrappedMapCodec, (Codec)valueCodec).flatComapMap(either -> (NestedSequenceBiMap.Entry)either.map(NestedSequenceBiMap.Entry.SubMapEntry::new, NestedSequenceBiMap.Entry.ValueEntry::new), entry -> entry.asValue().map(Either::right).map(DataResult::success).orElse(entry.asMap().map(EnumSequenceBiMap::cast).map(Either::left).map(DataResult::success).orElse(DataResult.error(() -> "Not a value or submap"))))).xmap(EnumSequenceBiMap::new, EnumSequenceBiMap::getEntryMap));
    }

    public static final <K extends Enum<K>, V> EnumSequenceBiMap<K, V> createRandom(Class<K> enumClass, Queue<V> values, Random random) {
        EnumSequenceBiMap<K, V> map = new EnumSequenceBiMap<K, V>(enumClass, values.size());
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        if (enumValues == null) {
            throw new IllegalStateException("Not an enum: " + enumClass.getName());
        }
        int depth = MathsHelper.floorLog(values.size(), enumValues.length);
        int leaves = MathsHelper.exponentiate(enumValues.length, depth);
        int smallLeafSize = values.size() / leaves;
        int bigLeaves = values.size() % leaves;
        Queue bigLeafEntries = IntStream.range(0, bigLeaves).mapToObj(i -> {
            ArrayList leafValues = new ArrayList(smallLeafSize + 1);
            for (int v = 0; v <= smallLeafSize; ++v) {
                leafValues.add(values.poll());
            }
            return EnumSequenceBiMap.createRandomLeafEntry((Enum[])enumValues, leafValues, (Random)random);
        }).collect(Collectors.toCollection(ArrayDeque::new));
        Queue smallLeafEntries = IntStream.range(0, leaves - bigLeaves).mapToObj(i -> {
            ArrayList leafValues = new ArrayList(smallLeafSize);
            for (int v = 0; v < smallLeafSize; ++v) {
                leafValues.add(values.poll());
            }
            return EnumSequenceBiMap.createRandomLeafEntry((Enum[])enumValues, leafValues, (Random)random);
        }).collect(Collectors.toCollection(ArrayDeque::new));
        EnumSequenceBiMap.populateRecursively(enumClass, (Enum[])enumValues, map, (Queue)bigLeafEntries, (Queue)smallLeafEntries, (Random)random, (int)depth);
        return map;
    }

    private static final <K extends Enum<K>, V> void populateRecursively(Class<K> enumClass, K[] enumValues, EnumSequenceBiMap<K, V> map, Queue<NestedSequenceBiMap.Entry<K, V>> bigLeafEntries, Queue<NestedSequenceBiMap.Entry<K, V>> smallLeafEntries, Random random, int recursionLeft) {
        if (recursionLeft == 0) {
            for (K key : enumValues) {
                map.entryMap.put(key, EnumSequenceBiMap.pollRandom(bigLeafEntries, smallLeafEntries, random));
            }
        } else {
            for (K key : enumValues) {
                EnumSequenceBiMap<K, V> subMap = new EnumSequenceBiMap<K, V>(enumClass, 0);
                EnumSequenceBiMap.populateRecursively(enumClass, enumValues, subMap, bigLeafEntries, smallLeafEntries, (Random)random, (int)(recursionLeft - 1));
                map.entryMap.put(key, new NestedSequenceBiMap.Entry.SubMapEntry<K, V>(subMap));
            }
        }
    }

    private static final <K extends Enum<K>, V> NestedSequenceBiMap.Entry<K, V> pollRandom(Queue<NestedSequenceBiMap.Entry<K, V>> bigLeafEntries, Queue<NestedSequenceBiMap.Entry<K, V>> smallLeafEntries, Random random) {
        if (bigLeafEntries.isEmpty()) {
            if (smallLeafEntries.isEmpty()) {
                throw new IllegalStateException();
            }
            return smallLeafEntries.poll();
        }
        if (smallLeafEntries.isEmpty()) {
            return bigLeafEntries.poll();
        }
        return random.nextBoolean() ? smallLeafEntries.poll() : bigLeafEntries.poll();
    }

    private static final <K extends Enum<K>, V> NestedSequenceBiMap.Entry<K, V> createRandomLeafEntry(K[] enumValues, List<V> values, Random random) {
        if (values.size() == 0 || values.size() > enumValues.length) {
            throw new IllegalArgumentException("Invalid number of values for leaf entry: " + values.size());
        }
        if (values.size() == 1) {
            return new NestedSequenceBiMap.Entry.ValueEntry(values.get(0));
        }
        if (values.size() == enumValues.length) {
            return new NestedSequenceBiMap.Entry.SubMapEntry<Enum, V>(new EnumSequenceBiMap<Enum, V>(IntStream.range(0, enumValues.length).boxed().collect(Collectors.toMap(i -> enumValues[i], i -> new NestedSequenceBiMap.Entry.ValueEntry(values.get((int)i))))));
        }
        List<K> randomEnumValues = List.of(enumValues);
        Collections.shuffle(randomEnumValues, random);
        randomEnumValues = randomEnumValues.subList(0, values.size());
        return new NestedSequenceBiMap.Entry.SubMapEntry<Enum, V>(new EnumSequenceBiMap<Enum, V>(IntStream.range(0, values.size()).boxed().collect(Collectors.toMap(randomEnumValues::get, i -> new NestedSequenceBiMap.Entry.ValueEntry(values.get((int)i))))));
    }
}

