/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.bolt;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import dev.lopyluna.dndecor.content.blocks.bolt.BoltRotation;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class BoltBlock
extends Block
implements IWrenchable {
    public static final VoxelShape SHAPE_DOWN = Block.box((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final VoxelShape SHAPE_UP = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);
    public static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0);
    public static final VoxelShape SHAPE_WEST = Block.box((double)13.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    public static final VoxelShape SHAPE_NORTH = Block.box((double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0, (double)16.0);
    public static final VoxelShape SHAPE_SOUTH = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)3.0);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final EnumProperty<BoltRotation> ROT = EnumProperty.create((String)"rotation", BoltRotation.class);

    public BoltBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue(ROT, (Comparable)((Object)BoltRotation.D0)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
        };
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.relative(dir.getOpposite()), (Direction)dir);
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ROT});
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction face = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockState base = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)face);
        if (!base.canSurvive((LevelReader)level, pos)) {
            return null;
        }
        BoltRotation rot = BoltRotation.D180;
        if (player != null && face.getAxis().isVertical()) {
            double yaw = player.getYRot();
            if (face == Direction.UP) {
                yaw = -(yaw + 180.0);
            }
            rot = BoltRotation.fromYaw(yaw);
        }
        return (BlockState)base.setValue(ROT, (Comparable)((Object)rot));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState rotated = (BlockState)state.setValue(ROT, (Comparable)((Object)((BoltRotation)((Object)state.getValue(ROT))).getNext()));
        if (!rotated.canSurvive((LevelReader)level, context.getClickedPos())) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)this.updateAfterWrenched(rotated, context));
        if (level.getBlockState(pos) != state) {
            this.playRotateSound(level, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState rotated = (BlockState)state.setValue(ROT, (Comparable)((Object)((BoltRotation)((Object)state.getValue(ROT))).getPrev()));
        if (!rotated.canSurvive((LevelReader)level, context.getClickedPos())) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)this.updateAfterWrenched(rotated, context));
        if (level.getBlockState(pos) != state) {
            this.playRotateSound(level, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void playRotateSound(Level level, BlockPos pos) {
        AllSoundEvents.WRENCH_ROTATE.playOnServer(level, (Vec3i)pos, 1.0f, level.random.nextFloat() + 0.5f);
    }
}

