/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.datagen;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import dev.lopyluna.dndecor.DnDecor;
import dev.lopyluna.dndecor.register.DnDecorTags;
import dev.lopyluna.dndecor.register.helpers.MetalTypeHelper;
import java.util.Map;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class DatagenTags {
    public static void addGenerators() {
        DnDecor.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, DatagenTags::genBlockTags);
        DnDecor.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, DatagenTags::genItemTags);
    }

    private static void genBlockTags(RegistrateTagsProvider<Block> provIn) {
        TagGen.CreateTagsProvider prov = new TagGen.CreateTagsProvider(provIn, Block::builtInRegistryHolder);
        TagGen.CreateTagAppender mineablePickaxe = prov.tag(BlockTags.MINEABLE_WITH_PICKAXE);
        TagGen.CreateTagAppender mineableAxe = prov.tag(BlockTags.MINEABLE_WITH_AXE);
        for (Map<String, TagKey<Block>> tag : MetalTypeHelper.mineableBlocksTag) {
            TagKey<Block> axe;
            TagKey<Block> pickaxe = tag.get("pickaxe");
            if (pickaxe != null) {
                mineablePickaxe.addOptionalTag(pickaxe);
            }
            if ((axe = tag.get("axe")) == null) continue;
            mineableAxe.addOptionalTag(axe);
        }
        for (DnDecorTags.BlockTags tag : DnDecorTags.BlockTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.getOrCreateRawBuilder(tag.tag);
        }
    }

    private static void genItemTags(RegistrateTagsProvider<Item> provIn) {
        TagGen.CreateTagsProvider prov = new TagGen.CreateTagsProvider(provIn, Item::builtInRegistryHolder);
        prov.tag(DnDecorTags.commonItemTag("create/crushing_wheels")).add((Object)AllBlocks.CRUSHING_WHEEL.asItem());
        prov.tag(DnDecorTags.commonItemTag("create/millstones")).add((Object)AllBlocks.MILLSTONE.asItem());
        prov.tag(DnDecorTags.commonItemTag("create/flywheels")).add((Object)AllBlocks.FLYWHEEL.asItem());
        prov.tag(DnDecorTags.commonItemTag("create/display_boards")).add((Object)AllBlocks.DISPLAY_BOARD.asItem());
        for (DnDecorTags.ItemTags tag : DnDecorTags.ItemTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.getOrCreateRawBuilder(tag.tag);
        }
    }
}

