/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.register.helpers.wood_types;

import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonnullType;
import dev.lopyluna.dndecor.DnDecor;
import dev.lopyluna.dndecor.register.DnDecorStoneTypes;
import dev.lopyluna.dndecor.register.DnDecorTags;
import dev.lopyluna.dndecor.register.helpers.wood_types.BlockPattern;
import java.util.List;
import java.util.function.Supplier;
import net.createmod.catnip.lang.Lang;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public abstract class BlockPartial<B extends Block> {
    public static final BlockPartial<StairBlock> STAIR = new Stairs();
    public static final BlockPartial<SlabBlock> SLAB = new Slab(false);
    public static final BlockPartial<SlabBlock> UNIQUE_SLAB = new Slab(true);
    public static final BlockPartial<WallBlock> WALL = new Wall();
    public static final BlockPartial<?>[] ALL_PARTIALS = new BlockPartial[]{STAIR, SLAB, WALL};
    public static final BlockPartial<?>[] FOR_POLISHED = new BlockPartial[]{STAIR, UNIQUE_SLAB, WALL};
    private final String name;

    private BlockPartial(String name) {
        this.name = name;
    }

    @NonnullType
    public BlockBuilder<B, CreateRegistrate> create(String variantName, BlockPattern pattern, BlockEntry<? extends Block> block, DnDecorStoneTypes variant) {
        String patternName = Lang.nonPluralId((String)pattern.createName(variantName));
        String blockName = patternName + "_" + this.name;
        BlockBuilder blockBuilder = (BlockBuilder)DnDecor.REGISTRATE.block(blockName, p -> this.createBlock((Supplier<Block>)block)).blockstate((c, p) -> this.generateBlockState((DataGenContext<Block, B>)c, (RegistrateBlockstateProvider)p, variantName, pattern, (Supplier<? extends Block>)((Supplier<Block>)block))).recipe((c, p) -> this.createRecipes(variant, (BlockEntry<? extends Block>)((BlockEntry<Block>)block), (DataGenContext<Block, ? extends Block>)((DataGenContext<Block, Block>)c), (RegistrateRecipeProvider)p)).transform(b -> this.transformBlock((BlockBuilder<B, CreateRegistrate>)b, variantName, pattern));
        ItemBuilder itemBuilder = (ItemBuilder)blockBuilder.item().transform(b -> this.transformItem((ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>>)b, variantName, pattern));
        if (this.canRecycle()) {
            itemBuilder.tag(new TagKey[]{variant.materialTag});
        }
        itemBuilder.tag(new TagKey[]{DnDecorTags.ItemTags.PALETTE_BLOCKS.tag});
        return (BlockBuilder)itemBuilder.build();
    }

    protected ResourceLocation getTexture(String variantName, BlockPattern pattern, int index) {
        return BlockPattern.toLocation(variantName, pattern.getTexture(index));
    }

    protected BlockBuilder<B, CreateRegistrate> transformBlock(BlockBuilder<B, CreateRegistrate> builder, String variantName, BlockPattern pattern) {
        this.getBlockTags().forEach(xva$0 -> builder.tag(new TagKey[]{xva$0}));
        return (BlockBuilder)builder.transform(TagGen.pickaxeOnly());
    }

    protected ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>> transformItem(ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>> builder, String variantName, BlockPattern pattern) {
        this.getItemTags().forEach(xva$0 -> builder.tag(new TagKey[]{xva$0}));
        return builder;
    }

    protected boolean canRecycle() {
        return true;
    }

    protected abstract Iterable<TagKey<Block>> getBlockTags();

    protected abstract Iterable<TagKey<Item>> getItemTags();

    protected abstract B createBlock(Supplier<? extends Block> var1);

    protected abstract void createRecipes(DnDecorStoneTypes var1, BlockEntry<? extends Block> var2, DataGenContext<Block, ? extends Block> var3, RegistrateRecipeProvider var4);

    protected abstract void generateBlockState(DataGenContext<Block, B> var1, RegistrateBlockstateProvider var2, String var3, BlockPattern var4, Supplier<? extends Block> var5);

    private static class Stairs
    extends BlockPartial<StairBlock> {
        public Stairs() {
            super("stairs");
        }

        @Override
        protected StairBlock createBlock(Supplier<? extends Block> block) {
            return new StairBlock(block.get().defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get())));
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, StairBlock> ctx, RegistrateBlockstateProvider prov, String variantName, BlockPattern pattern, Supplier<? extends Block> block) {
            prov.stairsBlock((StairBlock)ctx.get(), this.getTexture(variantName, pattern, 0));
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return List.of(BlockTags.STAIRS);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return List.of(ItemTags.STAIRS);
        }

        @Override
        protected void createRecipes(DnDecorStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            RecipeCategory category = RecipeCategory.BUILDING_BLOCKS;
            p.stairs(DataIngredient.items((ItemLike)((Block)patternBlock.get()), (ItemLike[])new Block[0]), category, c, c.getName(), false);
            p.stonecutting(DataIngredient.tag(type.materialTag), category, c, 1);
        }
    }

    private static class Slab
    extends BlockPartial<SlabBlock> {
        private final boolean customSide;

        public Slab(boolean customSide) {
            super("slab");
            this.customSide = customSide;
        }

        @Override
        protected SlabBlock createBlock(Supplier<? extends Block> block) {
            return new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get())));
        }

        @Override
        protected boolean canRecycle() {
            return false;
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, SlabBlock> ctx, RegistrateBlockstateProvider prov, String variantName, BlockPattern pattern, Supplier<? extends Block> block) {
            String name = ctx.getName();
            ResourceLocation mainTexture = this.getTexture(variantName, pattern, 0);
            ResourceLocation sideTexture = this.customSide ? this.getTexture(variantName, pattern, 1) : mainTexture;
            ModelBuilder bottom = prov.models().slab(name, sideTexture, mainTexture, mainTexture);
            ModelBuilder top = prov.models().slabTop(name + "_top", sideTexture, mainTexture, mainTexture);
            Object doubleSlab = this.customSide ? prov.models().cubeColumn(name + "_double", sideTexture, mainTexture) : prov.models().getExistingFile(prov.modLoc(pattern.createName(variantName)));
            prov.slabBlock((SlabBlock)ctx.get(), (ModelFile)bottom, (ModelFile)top, (ModelFile)doubleSlab);
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return List.of(BlockTags.SLABS);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return List.of(ItemTags.SLABS);
        }

        @Override
        protected void createRecipes(DnDecorStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            RecipeCategory category = RecipeCategory.BUILDING_BLOCKS;
            p.slab(DataIngredient.items((ItemLike)((Block)patternBlock.get()), (ItemLike[])new Block[0]), category, c, c.getName(), false);
            p.stonecutting(DataIngredient.tag(type.materialTag), category, c, 2);
            DataIngredient ingredient = DataIngredient.items((ItemLike)((Block)c.get()), (ItemLike[])new Block[0]);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)((ItemLike)patternBlock.get())).requires(ingredient.toVanilla()).requires(ingredient.toVanilla()).unlockedBy("has_" + c.getName(), ingredient.getCriterion(p)).save((RecipeOutput)p, "dndecor:" + c.getName() + "_recycling");
        }

        @Override
        protected BlockBuilder<SlabBlock, CreateRegistrate> transformBlock(BlockBuilder<SlabBlock, CreateRegistrate> builder, String variantName, BlockPattern pattern) {
            builder.loot((lt, block) -> lt.add((Block)block, lt.createSlabItemTable((Block)block)));
            return super.transformBlock(builder, variantName, pattern);
        }
    }

    private static class Wall
    extends BlockPartial<WallBlock> {
        public Wall() {
            super("wall");
        }

        @Override
        protected WallBlock createBlock(Supplier<? extends Block> block) {
            return new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get())).forceSolidOn());
        }

        @Override
        protected ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>> transformItem(ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>> builder, String variantName, BlockPattern pattern) {
            builder.model((c, p) -> p.wallInventory(c.getName(), this.getTexture(variantName, pattern, 0)));
            return super.transformItem(builder, variantName, pattern);
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, WallBlock> ctx, RegistrateBlockstateProvider prov, String variantName, BlockPattern pattern, Supplier<? extends Block> block) {
            prov.wallBlock((WallBlock)ctx.get(), pattern.createName(variantName), this.getTexture(variantName, pattern, 0));
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return List.of(BlockTags.WALLS);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return List.of(ItemTags.WALLS);
        }

        @Override
        protected void createRecipes(DnDecorStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            RecipeCategory category = RecipeCategory.BUILDING_BLOCKS;
            p.stonecutting(DataIngredient.tag(type.materialTag), category, c, 1);
            DataIngredient ingredient = DataIngredient.items((ItemLike)((Block)patternBlock.get()), (ItemLike[])new Block[0]);
            ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)((ItemLike)c.get()), (int)6).pattern("XXX").pattern("XXX").define(Character.valueOf('X'), ingredient.toVanilla()).unlockedBy("has_" + p.safeName(ingredient), ingredient.getCriterion(p)).save((RecipeOutput)p, p.safeId((ItemLike)c.get()));
        }
    }
}

