/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.datagen;

import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.jewelry.blocks.JewelryBlocks;
import net.jewelry.items.Gems;
import net.jewelry.items.JewelryItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class JewelryCraftingRecipes
extends FabricRecipeProvider {
    public JewelryCraftingRecipes(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super(output, registriesFuture);
    }

    public String getName() {
        return "Jewelry Crafting Recipes";
    }

    public void buildRecipes(RecipeOutput exporter) {
        this.generateBasicRings(exporter);
        this.generateGemJewelry(exporter);
        this.generateGemRings(exporter);
        this.generateGemNecklaces(exporter);
        this.generateNetheriteRings(exporter);
        this.generateNetheriteNecklaces(exporter);
        this.generateSpecialItems(exporter);
    }

    private void generateBasicRings(RecipeOutput exporter) {
        this.metalRing(exporter, JewelryItems.copper_ring.item(), Items.COPPER_INGOT);
        this.metalRing(exporter, JewelryItems.iron_ring.item(), Items.IRON_INGOT);
        this.metalRing(exporter, JewelryItems.gold_ring.item(), Items.GOLD_INGOT);
    }

    private void metalRing(RecipeOutput exporter, Item result, Item metal) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).pattern(" M ").pattern("M M").pattern(" M ").define(Character.valueOf('M'), (ItemLike)metal).unlockedBy(JewelryCraftingRecipes.getHasName((ItemLike)metal), JewelryCraftingRecipes.has((ItemLike)metal)).save(exporter);
    }

    private void generateGemJewelry(RecipeOutput exporter) {
        this.vanillaNecklace(exporter, JewelryItems.diamond_necklace.item(), Items.DIAMOND);
        this.gemRing(exporter, JewelryItems.diamond_ring.item(), Items.DIAMOND);
        this.vanillaNecklace(exporter, JewelryItems.emerald_necklace.item(), Items.EMERALD);
    }

    private void vanillaNecklace(RecipeOutput exporter, Item result, Item gem) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).pattern(" S ").pattern(" M ").pattern(" G ").define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('M'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('G'), (ItemLike)gem).unlockedBy(JewelryCraftingRecipes.getHasName((ItemLike)gem), JewelryCraftingRecipes.has((ItemLike)gem)).save(exporter);
    }

    private void generateGemRings(RecipeOutput exporter) {
        this.gemRing(exporter, JewelryItems.ruby_ring.item(), Gems.ruby.item());
        this.gemRing(exporter, JewelryItems.topaz_ring.item(), Gems.topaz.item());
        this.gemRing(exporter, JewelryItems.citrine_ring.item(), Gems.citrine.item());
        this.gemRing(exporter, JewelryItems.jade_ring.item(), Gems.jade.item());
        this.gemRing(exporter, JewelryItems.sapphire_ring.item(), Gems.sapphire.item());
        this.gemRing(exporter, JewelryItems.tanzanite_ring.item(), Gems.tanzanite.item());
    }

    private void gemRing(RecipeOutput exporter, Item result, Item gem) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).pattern(" G ").pattern("M M").pattern(" M ").define(Character.valueOf('G'), (ItemLike)gem).define(Character.valueOf('M'), (ItemLike)Items.GOLD_INGOT).unlockedBy(JewelryCraftingRecipes.getHasName((ItemLike)gem), JewelryCraftingRecipes.has((ItemLike)gem)).save(exporter);
    }

    private void generateGemNecklaces(RecipeOutput exporter) {
        this.gemNecklace(exporter, JewelryItems.ruby_necklace.item(), Gems.ruby.item());
        this.gemNecklace(exporter, JewelryItems.topaz_necklace.item(), Gems.topaz.item());
        this.gemNecklace(exporter, JewelryItems.citrine_necklace.item(), Gems.citrine.item());
        this.gemNecklace(exporter, JewelryItems.jade_necklace.item(), Gems.jade.item());
        this.gemNecklace(exporter, JewelryItems.sapphire_necklace.item(), Gems.sapphire.item());
        this.gemNecklace(exporter, JewelryItems.tanzanite_necklace.item(), Gems.tanzanite.item());
    }

    private void gemNecklace(RecipeOutput exporter, Item result, Item gem) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).pattern(" S ").pattern(" M ").pattern(" G ").define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('M'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('G'), (ItemLike)gem).unlockedBy(JewelryCraftingRecipes.getHasName((ItemLike)gem), JewelryCraftingRecipes.has((ItemLike)gem)).save(exporter);
    }

    private void generateNetheriteRings(RecipeOutput exporter) {
        this.netheriteRing(exporter, JewelryItems.netherite_ruby_ring.item(), Gems.ruby.item());
        this.netheriteRing(exporter, JewelryItems.netherite_topaz_ring.item(), Gems.topaz.item());
        this.netheriteRing(exporter, JewelryItems.netherite_citrine_ring.item(), Gems.citrine.item());
        this.netheriteRing(exporter, JewelryItems.netherite_jade_ring.item(), Gems.jade.item());
        this.netheriteRing(exporter, JewelryItems.netherite_sapphire_ring.item(), Gems.sapphire.item());
        this.netheriteRing(exporter, JewelryItems.netherite_tanzanite_ring.item(), Gems.tanzanite.item());
    }

    private void netheriteRing(RecipeOutput exporter, Item result, Item gem) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).pattern(" G ").pattern("M M").pattern(" N ").define(Character.valueOf('G'), (ItemLike)gem).define(Character.valueOf('M'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('N'), (ItemLike)Items.NETHERITE_INGOT).unlockedBy(JewelryCraftingRecipes.getHasName((ItemLike)Items.NETHERITE_INGOT), JewelryCraftingRecipes.has((ItemLike)gem)).save(exporter);
    }

    private void generateNetheriteNecklaces(RecipeOutput exporter) {
        this.netheriteNecklace(exporter, JewelryItems.netherite_ruby_necklace.item(), Gems.ruby.item());
        this.netheriteNecklace(exporter, JewelryItems.netherite_topaz_necklace.item(), Gems.topaz.item());
        this.netheriteNecklace(exporter, JewelryItems.netherite_citrine_necklace.item(), Gems.citrine.item());
        this.netheriteNecklace(exporter, JewelryItems.nsetherite_jade_necklace.item(), Gems.jade.item());
        this.netheriteNecklace(exporter, JewelryItems.netherite_sapphire_necklace.item(), Gems.sapphire.item());
        this.netheriteNecklace(exporter, JewelryItems.netherite_tanzanite_necklace.item(), Gems.tanzanite.item());
    }

    private void netheriteNecklace(RecipeOutput exporter, Item result, Item gem) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).pattern(" S ").pattern("TMT").pattern(" G ").define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('T'), (ItemLike)Items.GOLD_NUGGET).define(Character.valueOf('M'), (ItemLike)Items.NETHERITE_INGOT).define(Character.valueOf('G'), (ItemLike)gem).unlockedBy(JewelryCraftingRecipes.getHasName((ItemLike)Items.NETHERITE_INGOT), JewelryCraftingRecipes.has((ItemLike)gem)).save(exporter);
    }

    private void generateSpecialItems(RecipeOutput exporter) {
        this.jewelryKit(exporter);
    }

    private void jewelryKit(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)JewelryBlocks.JEWELERS_KIT.item()).pattern("CIG").pattern("###").define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('#'), ItemTags.PLANKS).unlockedBy(JewelryCraftingRecipes.getHasName((ItemLike)Items.COPPER_INGOT), JewelryCraftingRecipes.has((ItemLike)Items.COPPER_INGOT)).showNotification(false).save(exporter);
    }
}

