/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.datagen;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.jewelry.datagen.JewelryCraftingRecipes;
import net.jewelry.items.Gems;
import net.jewelry.items.JewelryItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;

public class JewelryDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(JewelryCraftingRecipes::new);
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(ModelProvider::new);
        pack.addProvider(UnsmeltGenerator::new);
    }

    public static class UnsmeltGenerator
    extends FabricRecipeProvider {
        public static int UNSMELT_TIME = 300;

        public UnsmeltGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        public String getName() {
            return "Jewelry Unsmelt Recipes";
        }

        public void buildRecipes(RecipeOutput exporter) {
            UnsmeltGenerator.disassemble(exporter, List.of(JewelryItems.gold_ring.item()), Items.GOLD_NUGGET);
            UnsmeltGenerator.disassemble(exporter, List.of(JewelryItems.iron_ring.item()), Items.IRON_NUGGET);
            UnsmeltGenerator.disassemble(exporter, List.of(JewelryItems.emerald_necklace.item()), Items.EMERALD);
            UnsmeltGenerator.disassemble(exporter, List.of(JewelryItems.diamond_necklace.item()), Items.DIAMOND);
            UnsmeltGenerator.disassemble(exporter, JewelryItems.all.stream().filter(entry -> entry.tier() == 2).map(entry -> entry.item()).toList(), Items.GOLD_NUGGET);
            UnsmeltGenerator.disassemble(exporter, JewelryItems.all.stream().filter(entry -> entry.id().getPath().contains("netherite")).map(entry -> entry.item()).toList(), Items.NETHERITE_SCRAP);
        }

        private static void disassemble(RecipeOutput exporter, List<ItemLike> items, Item output) {
            FabricRecipeProvider.oreSmelting((RecipeOutput)exporter, items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.oreBlasting((RecipeOutput)exporter, items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }
    }

    public static class ModelProvider
    extends FabricModelProvider {
        public ModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(BlockModelGenerators blockStateModelGenerator) {
        }

        public void generateItemModels(ItemModelGenerators itemModelGenerator) {
            Gems.all.forEach(gem -> itemModelGenerator.generateFlatItem(gem.item(), ModelTemplates.FLAT_ITEM));
            JewelryItems.all.forEach(entry -> itemModelGenerator.generateFlatItem(entry.item(), ModelTemplates.FLAT_ITEM));
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void addTags(HolderLookup.Provider wrapperLookup) {
            this.generateJewelryTags();
            this.generateLootTierTags();
        }

        private void generateJewelryTags() {
            FabricTagProvider.FabricTagBuilder gemsTag = this.getOrCreateTagBuilder(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"gems")));
            Gems.all.forEach(gem -> gemsTag.addOptional(gem.id()));
            FabricTagProvider.FabricTagBuilder ringsTag = this.getOrCreateTagBuilder(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"rings")));
            JewelryItems.all.stream().filter(entry -> entry.id().getPath().contains("ring")).forEach(entry -> ringsTag.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder necklacesTag = this.getOrCreateTagBuilder(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"necklaces")));
            JewelryItems.all.stream().filter(entry -> entry.id().getPath().contains("necklace")).forEach(entry -> necklacesTag.addOptional(entry.id()));
        }

        private void generateLootTierTags() {
            HashMap<ResourceLocation, Equipment.LootProperties> accessoriesMap = new HashMap<ResourceLocation, Equipment.LootProperties>();
            for (JewelryItems.Entry entry : JewelryItems.all) {
                Equipment.LootProperties lootProperties = new Equipment.LootProperties(entry.tier(), null);
                accessoriesMap.put(entry.id(), lootProperties);
            }
            this.generateAccessoryTags(accessoriesMap);
        }
    }
}

