/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import com.mojang.blaze3d.platform.NativeImage;
import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.net.MessagePartialImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class ImageProcessor {
    public static void sendScreenshot(UUID uuid, BufferedImage image) {
        byte[] data;
        try {
            data = ImageTools.optimizeImage(image);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        int size = data.length;
        if (size < 30000) {
            PacketDistributor.sendToServer((CustomPacketPayload)new MessagePartialImage(uuid, 0, size, data), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            int bufferProgress = 0;
            byte[] currentBuffer = new byte[30000];
            for (int i = 0; i < size; ++i) {
                if (bufferProgress >= currentBuffer.length) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new MessagePartialImage(uuid, i - currentBuffer.length, data.length, currentBuffer), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    bufferProgress = 0;
                    currentBuffer = new byte[currentBuffer.length];
                }
                currentBuffer[bufferProgress] = data[i];
                ++bufferProgress;
            }
            if (bufferProgress > 0) {
                byte[] rest = new byte[bufferProgress];
                System.arraycopy(currentBuffer, 0, rest, 0, bufferProgress);
                PacketDistributor.sendToServer((CustomPacketPayload)new MessagePartialImage(uuid, size - rest.length, data.length, rest), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static void sendScreenshotThreaded(UUID uuid, BufferedImage image) {
        new Thread(() -> ImageProcessor.sendScreenshot(uuid, image), "ProcessImageThread").start();
    }

    public static void sendScreenshotThreaded(UUID uuid, NativeImage image) {
        new Thread(() -> ImageProcessor.sendScreenshot(uuid, ImageTools.fromNativeImage(image)), "ProcessImageThread").start();
    }
}

