/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.gui.AlbumContainer;
import de.maxhenkel.camera.gui.ImageScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class AlbumScreen
extends AbstractContainerScreen<AlbumContainer> {
    protected int index;
    protected List<UUID> images;
    private boolean wasNextDown;
    private boolean wasPreviousDown;

    public AlbumScreen(AlbumContainer screenContainer, Inventory inv, Component titleIn, List<UUID> images) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.images = images;
    }

    public AlbumScreen(AlbumContainer screenContainer, Inventory inv, Component titleIn) {
        this(screenContainer, inv, titleIn, new ArrayList<UUID>());
    }

    public AlbumScreen(List<UUID> images) {
        this(new AlbumContainer(-1), Minecraft.getInstance().player.getInventory(), (Component)Component.translatable((String)"gui.album.title"), images);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderTransparentBackground(guiGraphics);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.images.isEmpty()) {
            return;
        }
        UUID uuid = this.images.get(this.index);
        ImageScreen.drawImage(guiGraphics, this.minecraft, this.width, this.height, 100.0f, uuid);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaY < 0.0) {
            this.next();
        } else {
            this.previous();
        }
        return true;
    }

    protected void next() {
        this.setIndex(this.index + 1);
    }

    protected void previous() {
        this.setIndex(this.index - 1);
    }

    protected void setIndex(int i) {
        if (this.index == i) {
            return;
        }
        this.index = i;
        if (this.index >= this.images.size()) {
            this.index = 0;
        } else if (this.index < 0) {
            this.index = this.images.size() - 1;
        }
        this.playPageTurnSound();
    }

    protected void playPageTurnSound() {
        this.minecraft.player.playNotifySound(SoundEvents.BOOK_PAGE_TURN, SoundSource.MASTER, 1.0f, this.minecraft.level.random.nextFloat() * 0.1f + 0.9f);
    }

    public void containerTick() {
        super.containerTick();
        boolean isNextDown = InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)Main.KEY_NEXT.getKey().getValue());
        boolean isPreviousDown = InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)Main.KEY_PREVIOUS.getKey().getValue());
        this.wasNextDown = isNextDown;
        if (this.wasNextDown != this.wasNextDown && !isNextDown) {
            this.next();
        } else {
            this.wasPreviousDown = isPreviousDown;
            if (this.wasPreviousDown != this.wasPreviousDown && !isPreviousDown) {
                this.previous();
            }
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
    }
}

