/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.items;

import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.corelib.client.CustomRendererItem;
import de.maxhenkel.camera.corelib.client.ItemRenderer;
import de.maxhenkel.camera.gui.ImageScreen;
import de.maxhenkel.camera.items.render.ImageItemRenderer;
import java.util.Date;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ImageItem
extends CustomRendererItem {
    public ImageItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemRenderer createItemRenderer() {
        return new ImageItemRenderer();
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn.level().isClientSide) {
            this.openClientGui(stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openClientGui(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new ImageScreen(stack));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        ImageData data = ImageData.fromStack(stack);
        if (data != null) {
            long time;
            String name = data.getOwner();
            if (!name.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.image_owner", (Object[])new Object[]{String.valueOf(ChatFormatting.DARK_GRAY) + name}).withStyle(ChatFormatting.GRAY));
            }
            if ((time = data.getTime()) > 0L) {
                tooltip.add((Component)Component.translatable((String)"tooltip.image_time", (Object[])new Object[]{String.valueOf(ChatFormatting.DARK_GRAY) + Main.CLIENT_CONFIG.imageDateFormat.format(new Date(time))}).withStyle(ChatFormatting.GRAY));
            }
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

