/*
 * Decompiled with CFR 0.152.
 */
package net.archers.client;

import java.util.List;
import java.util.function.Supplier;
import mod.azure.azurelibarmor.common.render.armor.AzArmorRenderer;
import mod.azure.azurelibarmor.common.render.armor.AzArmorRendererRegistry;
import net.archers.client.armor.ArcherArmorRenderer;
import net.archers.client.effect.HuntersMarkRenderer;
import net.archers.client.effect.RootsRenderer;
import net.archers.client.util.ArchersTooltip;
import net.archers.effect.ArcherEffects;
import net.archers.item.ArcherArmors;
import net.archers.item.Quivers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.render.CustomModels;
import net.spell_engine.client.gui.SpellTooltip;

public class ArchersClientMod {
    public static void init() {
        CustomModels.registerModelIds(List.of(HuntersMarkRenderer.modelId, RootsRenderer.modelId, ResourceLocation.fromNamespaceAndPath((String)"archers", (String)"projectile/magic_arrow")));
        CustomModelStatusEffect.register((MobEffect)ArcherEffects.HUNTERS_MARK.effect, (CustomModelStatusEffect.Renderer)new HuntersMarkRenderer());
        CustomModelStatusEffect.register((MobEffect)ArcherEffects.ENTANGLING_ROOTS.effect, (CustomModelStatusEffect.Renderer)new RootsRenderer());
        ArchersTooltip.init();
        SpellTooltip.addDescriptionMutator((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"archers", (String)"power_shot"), args -> {
            String description = args.description();
            String huntersMarkPercent = SpellTooltip.percent((float)ArcherEffects.HUNTERS_MARK.config().firstModifier().value);
            description = description.replace(SpellTooltip.placeholder((String)"damage_taken"), huntersMarkPercent);
            return description;
        });
        ArchersClientMod.registerArmorRenderer(ArcherArmors.archerArmorSet_T1, ArcherArmorRenderer::archer);
        ArchersClientMod.registerArmorRenderer(ArcherArmors.archerArmorSet_T2, ArcherArmorRenderer::ranger);
        ArchersClientMod.registerArmorRenderer(ArcherArmors.archerArmorSet_T3, ArcherArmorRenderer::netheriteRanger);
        List<ResourceLocation> quiverModels = Quivers.entries.stream().map(entry -> ResourceLocation.fromNamespaceAndPath((String)"archers", (String)("item/quiver/" + entry.id().getPath()))).toList();
        CustomModels.registerModelIds(quiverModels);
    }

    private static void registerArmorRenderer(Armor.Set set, Supplier<AzArmorRenderer> armorRendererSupplier) {
        AzArmorRendererRegistry.register(armorRendererSupplier, (Item)set.head, (Item[])new Item[]{set.chest, set.legs, set.feet});
    }
}

