/*
 * Decompiled with CFR 0.152.
 */
package net.armory_rpgs.datagen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.armory_rpgs.datagen.recipe.SmithingRecipeProvider;
import net.armory_rpgs.datagen.recipe.SmithingUpgradeRecipe;
import net.armory_rpgs.item.ArmorSets;
import net.armory_rpgs.item.FightClass;
import net.armory_rpgs.item.Group;
import net.armory_rpgs.item.SmithingTemplates;
import net.armory_rpgs.item.SmtihingIngredients;
import net.armory_rpgs.spell.ArmoryEffects;
import net.armory_rpgs.spell.ArmorySounds;
import net.armory_rpgs.spell.ArmorySpells;
import net.armory_rpgs.spell.SetBonuses;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.datagen.SimpleSoundGeneratorV2;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.item.set.EquipmentSet;
import net.spell_engine.api.item.set.EquipmentSetRegistry;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;

public class ArmoryDataGen
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(SpellTagGenerator::new);
        pack.addProvider(LangGenerator::new);
        pack.addProvider(ModelProvider::new);
        pack.addProvider(SpellGen::new);
        pack.addProvider(SoundGen::new);
        pack.addProvider(EquipmentSetGenerator::new);
        pack.addProvider(RecipeGenerator::new);
        pack.addProvider(SmithGen::new);
    }

    private static List<Item> allArmorPieces() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Armor.Entry entry : ArmorSets.entries) {
            entry.armorSet().pieces().forEach(item -> items.add((Item)item));
        }
        return items;
    }

    public static class SmithGen
    extends SmithingRecipeProvider {
        public Map<FightClass, List<Upgrade>> UPGRADES = Map.of(FightClass.ARCHER, List.of(new Upgrade(new ArmorIdSet("archers", "ranger_armor"), ArmorSets.strider.armorSet(), null)), FightClass.ARCANE_WIZARD, List.of(new Upgrade(new ArmorIdSet("wizards", "arcane_robe"), ArmorSets.astral.armorSet(), null)), FightClass.FIRE_WIZARD, List.of(new Upgrade(new ArmorIdSet("wizards", "fire_robe"), ArmorSets.scarlet.armorSet(), null)), FightClass.FROST_WIZARD, List.of(new Upgrade(new ArmorIdSet("wizards", "frost_robe"), ArmorSets.glacier.armorSet(), null)), FightClass.PRIEST, List.of(new Upgrade(new ArmorIdSet("paladins", "prior_robe"), ArmorSets.avatar.armorSet(), null)), FightClass.PALADIN, List.of(new Upgrade(new ArmorIdSet("paladins", "crusader_armor"), ArmorSets.justicar.armorSet(), null)), FightClass.ROGUE, List.of(new Upgrade(new ArmorIdSet("rogues", "assassin_armor"), ArmorSets.deathmantle.armorSet(), null)), FightClass.WARRIOR, List.of(new Upgrade(new ArmorIdSet("rogues", "berserker_armor"), ArmorSets.destroyer.armorSet(), null)));

        public SmithGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        @Override
        public void generateRecipes(SmithingRecipeProvider.Builder builder) {
            HashMap autoAssignedUpgrades = new HashMap();
            this.UPGRADES.forEach((fightClass, upgrades) -> {
                ArrayList<Upgrade> newList = new ArrayList<Upgrade>();
                for (Upgrade upgrade : upgrades) {
                    if (upgrade.ingredient != null) continue;
                    SmtihingIngredients.UpgradeCrystal ingredient = ((SmtihingIngredients.Entry)SmtihingIngredients.ENTRIES.stream().filter(entry -> entry.classes().contains(fightClass)).findFirst().orElse(null)).item().get();
                    newList.add(new Upgrade(upgrade.from, upgrade.to, ingredient));
                }
                autoAssignedUpgrades.put(fightClass, newList);
            });
            boolean includeNetherite = true;
            for (SmithingTemplates.Entry template : SmithingTemplates.ENTRIES) {
                for (Map.Entry entry : autoAssignedUpgrades.entrySet()) {
                    ResourceLocation id;
                    ResourceLocation itemId;
                    SmithingUpgradeRecipe builderEntry;
                    String ingredientId;
                    FightClass figthClass = (FightClass)((Object)entry.getKey());
                    ArrayList<Upgrade> upgrades2 = (ArrayList<Upgrade>)entry.getValue();
                    if (upgrades2 == null) continue;
                    if (includeNetherite) {
                        ArrayList<Upgrade> list = new ArrayList<Upgrade>(upgrades2);
                        for (Upgrade upgrade : upgrades2) {
                            list.add(upgrade.prefixVariant("netherite"));
                        }
                        upgrades2 = list;
                    }
                    for (Upgrade upgradeType : upgrades2) {
                        ingredientId = ((ResourceKey)upgradeType.ingredient().builtInRegistryHolder().unwrapKey().get()).location().toString();
                        builderEntry = SmithingUpgradeRecipe.ofStringsWithConditions(template.id().toString(), upgradeType.from.headId().toString(), ingredientId, upgradeType.to.idOf(upgradeType.to.head).toString(), upgradeType.from.namespace());
                        itemId = upgradeType.to.idOf(upgradeType.to.head);
                        id = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("smithing_" + itemId.getPath() + "_" + upgradeType.from.headId().getPath()));
                        builder.entries.add(new SmithingRecipeProvider.Entry(id, builderEntry));
                    }
                    for (Upgrade upgradeType : upgrades2) {
                        ingredientId = ((ResourceKey)upgradeType.ingredient().builtInRegistryHolder().unwrapKey().get()).location().toString();
                        builderEntry = SmithingUpgradeRecipe.ofStringsWithConditions(template.id().toString(), upgradeType.from.chestId().toString(), ingredientId, upgradeType.to.idOf(upgradeType.to.chest).toString(), upgradeType.from.namespace());
                        itemId = upgradeType.to.idOf(upgradeType.to.chest);
                        id = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("smithing_" + itemId.getPath() + "_" + upgradeType.from.chestId().getPath()));
                        builder.entries.add(new SmithingRecipeProvider.Entry(id, builderEntry));
                    }
                    for (Upgrade upgradeType : upgrades2) {
                        ingredientId = ((ResourceKey)upgradeType.ingredient().builtInRegistryHolder().unwrapKey().get()).location().toString();
                        builderEntry = SmithingUpgradeRecipe.ofStringsWithConditions(template.id().toString(), upgradeType.from.legsId().toString(), ingredientId, upgradeType.to.idOf(upgradeType.to.legs).toString(), upgradeType.from.namespace());
                        itemId = upgradeType.to.idOf(upgradeType.to.legs);
                        id = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("smithing_" + itemId.getPath() + "_" + upgradeType.from.legsId().getPath()));
                        builder.entries.add(new SmithingRecipeProvider.Entry(id, builderEntry));
                    }
                    for (Upgrade upgradeType : upgrades2) {
                        ingredientId = ((ResourceKey)upgradeType.ingredient().builtInRegistryHolder().unwrapKey().get()).location().toString();
                        builderEntry = SmithingUpgradeRecipe.ofStringsWithConditions(template.id().toString(), upgradeType.from.feetId().toString(), ingredientId, upgradeType.to.idOf(upgradeType.to.feet).toString(), upgradeType.from.namespace());
                        itemId = upgradeType.to.idOf(upgradeType.to.feet);
                        id = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("smithing_" + itemId.getPath() + "_" + upgradeType.from.feetId().getPath()));
                        builder.entries.add(new SmithingRecipeProvider.Entry(id, builderEntry));
                    }
                }
            }
        }

        public record Upgrade(ArmorIdSet from, Armor.Set to, Item ingredient) {
            public Upgrade prefixVariant(String variant) {
                return new Upgrade(new ArmorIdSet(this.from.namespace(), variant + "_" + this.from.name()), this.to, this.ingredient);
            }
        }

        public record ArmorIdSet(String namespace, String name) {
            public ResourceLocation headId() {
                return ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)(this.name + "_" + EquipmentSlot.HEAD.getSerializedName().toLowerCase()));
            }

            public ResourceLocation chestId() {
                return ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)(this.name + "_" + EquipmentSlot.CHEST.getSerializedName().toLowerCase()));
            }

            public ResourceLocation legsId() {
                return ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)(this.name + "_" + EquipmentSlot.LEGS.getSerializedName().toLowerCase()));
            }

            public ResourceLocation feetId() {
                return ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)(this.name + "_" + EquipmentSlot.FEET.getSerializedName().toLowerCase()));
            }
        }
    }

    public static class RecipeGenerator
    extends FabricRecipeProvider {
        public RecipeGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        public void buildRecipes(RecipeOutput recipeExporter) {
            SmithingTemplates.ENTRIES.forEach(entry -> FabricRecipeProvider.copySmithingTemplate((RecipeOutput)recipeExporter, (ItemLike)((ItemLike)entry.item().get()), (ItemLike)Items.DIAMOND));
        }
    }

    public static class EquipmentSetGenerator
    extends FabricDynamicRegistryProvider {
        public EquipmentSetGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void configure(HolderLookup.Provider registries, FabricDynamicRegistryProvider.Entries entries) {
            HolderGetter itemLookup = registries.asGetterLookup().lookupOrThrow(Registries.ITEM);
            for (SetBonuses.Entry set : SetBonuses.all) {
                HolderSet.Direct items = HolderSet.direct(set.itemSupplier().get().stream().map(id -> itemLookup.getOrThrow(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id))).toList());
                entries.add(ResourceKey.create((ResourceKey)EquipmentSetRegistry.KEY, (ResourceLocation)set.id()), (Object)new EquipmentSet.Definition(set.id().getPath(), (HolderSet)items, set.bonuses()));
            }
        }

        public String getName() {
            return "Equipment Set Generator";
        }
    }

    public static class SoundGen
    extends SimpleSoundGeneratorV2 {
        public SoundGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSounds(SimpleSoundGeneratorV2.Builder builder) {
            builder.entries.add(new SimpleSoundGeneratorV2.Entry("armory_rpgs", ArmorySounds.entries.stream().map(entry -> SimpleSoundGeneratorV2.SoundEntry.withVariants((String)entry.id().getPath(), (int)entry.variants())).toList()));
        }
    }

    public static class SpellGen
    extends SpellGenerator {
        public SpellGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (ArmorySpells.Entry entry : ArmorySpells.all) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }

    public static class ModelProvider
    extends FabricModelProvider {
        public ModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(BlockModelGenerators blockStateModelGenerator) {
        }

        public void generateItemModels(ItemModelGenerators itemModelGenerator) {
            SmtihingIngredients.ENTRIES.forEach(entry -> itemModelGenerator.generateFlatItem((Item)entry.item().get(), ModelTemplates.FLAT_ITEM));
            SmithingTemplates.ENTRIES.forEach(entry -> itemModelGenerator.generateFlatItem((Item)entry.item().get(), ModelTemplates.FLAT_ITEM));
            ArmorSets.entries.forEach(entry -> {
                for (Object piece : entry.armorSet().pieces()) {
                    itemModelGenerator.generateFlatItem((Item)piece, ModelTemplates.FLAT_ITEM);
                }
            });
        }
    }

    public static class LangGenerator
    extends FabricLanguageProvider {
        protected LangGenerator(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(HolderLookup.Provider wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
            translationBuilder.add(Group.translationKey, "Armory");
            translationBuilder.add(SmtihingIngredients.UpgradeCrystal.HINT_TRANSLATION_KEY, "Armor upgrade crystal");
            SmtihingIngredients.ENTRIES.forEach(entry -> {
                translationBuilder.add(entry.item().get().getDescriptionId(), entry.translations().itemName());
                translationBuilder.add(entry.appliesToTranslationKey(), entry.appliesToClassesTranslation());
            });
            SmithingTemplates.ENTRIES.forEach(entry -> {
                translationBuilder.add(entry.item().get().getDescriptionId(), entry.translations().itemName());
                translationBuilder.add(entry.upgradeTranslationKey(), entry.translations().upgradeName());
                translationBuilder.add(entry.baseSlotDescriptionTranslationKey(), entry.translations().baseSlotDescription());
                translationBuilder.add(entry.additionsSlotDescriptionTranslationKey(), entry.translations().additionsSlotDescription());
                translationBuilder.add(entry.appliesToTranslationKey(), entry.translations().appliesTo());
                translationBuilder.add(entry.ingredientsTranslationKey(), entry.translations().ingredients());
            });
            ArmorSets.entries.forEach(entry -> {
                LinkedHashMap<String, String> translations = new LinkedHashMap<String, String>();
                translations.put(entry.armorSet().head.getDescriptionId(), entry.armorSet().headTranslation);
                translations.put(entry.armorSet().chest.getDescriptionId(), entry.armorSet().chestTranslation);
                translations.put(entry.armorSet().legs.getDescriptionId(), entry.armorSet().legsTranslation);
                translations.put(entry.armorSet().feet.getDescriptionId(), entry.armorSet().feetTranslation);
                for (Map.Entry armorEntry : translations.entrySet()) {
                    translationBuilder.add((String)armorEntry.getKey(), (String)armorEntry.getValue());
                }
            });
            SetBonuses.all.forEach(entry -> translationBuilder.add(EquipmentSet.translationKey((ResourceLocation)entry.id()), entry.title()));
            ArmorySpells.all.forEach(entry -> {
                ResourceLocation id = entry.id();
                translationBuilder.add("spell." + id.getNamespace() + "." + id.getPath() + ".name", entry.title());
                translationBuilder.add("spell." + id.getNamespace() + "." + id.getPath() + ".description", entry.description());
            });
            ArmoryEffects.entries.forEach(entry -> {
                translationBuilder.add(entry.effect.getDescriptionId(), entry.title);
                translationBuilder.add(entry.effect.getDescriptionId() + ".description", entry.description);
            });
        }
    }

    public static class SpellTagGenerator
    extends FabricTagProvider<Spell> {
        public SpellTagGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, SpellRegistry.KEY, registriesFuture);
        }

        protected void addTags(HolderLookup.Provider wrapperLookup) {
            ArmorySpells.all.forEach(entry -> {
                for (ArmorySpells.Category category : entry.categories()) {
                    TagKey tagKey = TagKey.create((ResourceKey)SpellRegistry.KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)category.toString().toLowerCase()));
                    FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(tagKey);
                    tag.addOptional(entry.id());
                }
            });
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void addTags(HolderLookup.Provider wrapperLookup) {
            RPGSeriesDataGen.ItemTagGenerator.ArmorOptions armorTagOptions = new RPGSeriesDataGen.ItemTagGenerator.ArmorOptions(false, true);
            this.generateArmorTags(ArmorSets.entries.stream().filter(entry -> entry.name().contains("archer")).toList(), RPGSeriesItemTags.ArmorMetaType.ARCHERY, armorTagOptions);
            this.generateArmorTags(ArmorSets.entries.stream().filter(entry -> entry.name().contains("armor")).toList(), RPGSeriesItemTags.ArmorMetaType.MELEE, armorTagOptions);
            this.generateArmorTags(ArmorSets.entries.stream().filter(entry -> entry.name().contains("robe")).toList(), RPGSeriesItemTags.ArmorMetaType.MAGIC, armorTagOptions);
            TagKey tierTag = RPGSeriesItemTags.LootTiers.get((int)ArmorSets.astral.lootProperties().tier(), (RPGSeriesItemTags.LootCategory)RPGSeriesItemTags.LootCategory.ARMORS);
            SmithingTemplates.ENTRIES.forEach(entry -> {
                FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(tierTag);
                tag.addOptional(entry.id());
            });
            SmtihingIngredients.ENTRIES.forEach(entry -> {
                FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(tierTag);
                tag.addOptional(entry.id());
            });
        }
    }
}

