/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.mountsofmayhem.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.gospi.mountsofmayhem.init.MountsOfMayhemModEntities;
import net.gospi.mountsofmayhem.procedures.NautilusPriNachalnomPrizyvieSushchnostiProcedure;
import net.gospi.mountsofmayhem.procedures.NautilusTestPriGibieliSushchnostiProcedure;
import net.gospi.mountsofmayhem.procedures.NautilusTestPriObnovlieniiTikaSushchnostiProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class NautilusEntity
extends TamableAnimal {
    public final AnimationState animationState0 = new AnimationState();
    private Vec3 externalMotion = Vec3.ZERO;

    public NautilusEntity(EntityType<NautilusEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (NautilusEntity.this.isInWater()) {
                    NautilusEntity.this.setDeltaMovement(NautilusEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !NautilusEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - NautilusEntity.this.getX();
                    double dy = this.wantedY - NautilusEntity.this.getY();
                    double dz = this.wantedZ - NautilusEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * NautilusEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    NautilusEntity.this.setYRot(this.rotlerp(NautilusEntity.this.getYRot(), f, 10.0f));
                    NautilusEntity.this.yBodyRot = NautilusEntity.this.getYRot();
                    NautilusEntity.this.yHeadRot = NautilusEntity.this.getYRot();
                    if (NautilusEntity.this.isInWater()) {
                        NautilusEntity.this.setSpeed((float)NautilusEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        NautilusEntity.this.setXRot(this.rotlerp(NautilusEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(NautilusEntity.this.getXRot() * ((float)Math.PI / 180)));
                        NautilusEntity.this.setZza(f3 * f1);
                        NautilusEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        NautilusEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    NautilusEntity.this.setSpeed(0.0f);
                    NautilusEntity.this.setYya(0.0f);
                    NautilusEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Pufferfish.class, false, true));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.PUFFERFISH}), false));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"mounts_of_mayhem:entity.nautilus.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"mounts_of_mayhem:entity.nautilus.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"mounts_of_mayhem:entity.nautilus.death"));
    }

    public void die(DamageSource source) {
        super.die(source);
        NautilusTestPriGibieliSushchnostiProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        NautilusPriNachalnomPrizyvieSushchnostiProcedure.execute((Entity)this);
        return retval;
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.isInWater()) {
            Vec3 motion = this.getDeltaMovement();
            if (motion.y < 0.0) {
                this.setDeltaMovement(motion.x, motion.y * 0.3, motion.z);
            }
        }
        if (!this.externalMotion.equals((Object)Vec3.ZERO)) {
            this.setDeltaMovement(this.getDeltaMovement().add(this.externalMotion));
            this.externalMotion = Vec3.ZERO;
        }
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
        }
    }

    public void addExternalMotion(Vec3 motion) {
        this.externalMotion = this.externalMotion.add(motion);
    }

    public void baseTick() {
        super.baseTick();
        NautilusTestPriObnovlieniiTikaSushchnostiProcedure.execute((Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        NautilusEntity retval = (NautilusEntity)((EntityType)MountsOfMayhemModEntities.NAUTILUS.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.PUFFERFISH), new ItemStack((ItemLike)Items.PUFFERFISH_BUCKET)}).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void travel(Vec3 dir) {
        LivingEntity passenger;
        if (this.isVehicle() && (passenger = this.getControllingPassenger()) != null) {
            this.setYRot(passenger.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(passenger.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yBodyRot = this.getYRot();
            this.yHeadRot = this.getYRot();
            float forward = passenger.zza;
            float strafe = passenger.xxa;
            if (this.isInWater()) {
                float baseSpeed = (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 2.0f;
                float pitch = passenger.getXRot();
                float pitchRad = pitch * ((float)Math.PI / 180);
                float yawRad = passenger.getYRot() * ((float)Math.PI / 180);
                float verticalFactor = Math.abs(pitch) / 90.0f;
                float horizontalSpeed = baseSpeed * (1.0f - verticalFactor * 0.7f);
                float verticalSpeed = baseSpeed * verticalFactor * 1.5f;
                float moveX = -Mth.sin((float)yawRad);
                float moveZ = Mth.cos((float)yawRad);
                float verticalDirection = -Mth.sin((float)pitchRad);
                double desiredX = 0.0;
                double desiredY = 0.0;
                double desiredZ = 0.0;
                if (forward != 0.0f) {
                    desiredX += (double)(moveX * forward * horizontalSpeed);
                    desiredZ += (double)(moveZ * forward * horizontalSpeed);
                    desiredY += (double)(verticalDirection * Math.abs(forward) * verticalSpeed);
                }
                if (strafe != 0.0f) {
                    float strafeX = -Mth.sin((float)(yawRad - 1.5707964f));
                    float strafeZ = Mth.cos((float)(yawRad - 1.5707964f));
                    desiredX += (double)(strafeX * strafe * horizontalSpeed);
                    desiredZ += (double)(strafeZ * strafe * horizontalSpeed);
                }
                this.setDeltaMovement(desiredX, desiredY, desiredZ);
            }
            super.travel(new Vec3((double)strafe, 0.0, (double)forward));
            this.tryCheckInsideBlocks();
            return;
        }
        super.travel(dir);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity passenger = this.getFirstPassenger();
        if (passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            return living;
        }
        return null;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)MountsOfMayhemModEntities.NAUTILUS.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos).is(Blocks.WATER) && world.getBlockState(pos.above()).is(Blocks.WATER), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.15);
        builder = builder.add(Attributes.MAX_HEALTH, 12.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 8.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.1);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 1.5);
        return builder;
    }
}

